/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    int element_internal_type;
    int max_num_of_elements;
    int element_max_len;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    int ibtMetaIndex;
    int ibtByteLength;
    int ibtCharLength;

    PlsqlIndexTableAccessor(OracleStatement oracleStatement, int n, int n2, int n3, int n4, short s, boolean bl) throws SQLException {
        this.init(oracleStatement, 998, 998, s, bl);
        this.element_internal_type = n2;
        this.max_num_of_elements = n4;
        this.element_max_len = n3;
        this.initForDataAccess(n, n3, null);
    }

    Datum[] getOraclePlsqlIndexTable(int n) throws SQLException {
        Datum[] datumArray = null;
        switch (this.element_internal_type) {
            case 9: {
                int n2 = (this.stmt.ibtBindIndicators[this.ibtMetaIndex + 4] >> 16) + this.stmt.ibtBindIndicators[this.ibtMetaIndex + 5];
                datumArray = new CHAR[n2];
                int n3 = this.ibtValueIndex;
                CharacterSet characterSet = CharacterSet.make(2000);
                int n4 = 0;
                while (n4 < n2) {
                    if (this.stmt.ibtBindIndicators[this.ibtIndicatorIndex + n4] == -1) {
                        datumArray[n4] = null;
                    } else {
                        int n5 = this.stmt.ibtBindChars[n3] >> 1;
                        byte[] byArray = new byte[n5 * 2];
                        DBConversion.javaCharsToUcs2Bytes(this.stmt.ibtBindChars, n3 + 1, byArray, 0, n5);
                        datumArray[n4] = new CHAR(byArray, characterSet);
                    }
                    n3 += this.element_max_len;
                    ++n4;
                }
                break;
            }
            case 6: {
                int n6 = (this.stmt.ibtBindIndicators[this.ibtMetaIndex + 4] >> 16) + this.stmt.ibtBindIndicators[this.ibtMetaIndex + 5];
                datumArray = new NUMBER[n6];
                int n7 = this.ibtValueIndex;
                int n8 = 0;
                while (n8 < n6) {
                    if (this.stmt.ibtBindIndicators[this.ibtIndicatorIndex + n8] == -1) {
                        datumArray[n8] = null;
                    } else {
                        byte by = this.stmt.ibtBindBytes[n7];
                        byte[] byArray = new byte[by];
                        System.arraycopy(this.stmt.ibtBindBytes, n7 + 1, byArray, 0, by);
                        datumArray[n8] = new NUMBER(byArray);
                    }
                    n7 += this.element_max_len;
                    ++n8;
                }
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
            }
        }
        return datumArray;
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        switch (this.element_internal_type) {
            case 1: 
            case 96: {
                this.t_max_length = 2000;
                this.element_max_len = (n2 == 0 ? this.t_max_length : n2) + 1;
                this.ibtCharLength = this.element_max_len * this.max_num_of_elements;
                this.element_internal_type = 9;
                break;
            }
            case 6: {
                this.t_max_length = 21;
                this.element_max_len = this.t_max_length + 1;
                this.ibtByteLength = this.element_max_len * this.max_num_of_elements;
                break;
            }
            default: {
                DatabaseError.throwSqlException(97);
            }
        }
    }
}

