/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILobd;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.net.ns.BreakNetException;
import oracle.sql.Datum;

abstract class T4C8TTILob
extends T4CTTIfun {
    static final int KPLOB_READ = 2;
    static final int KPLOB_WRITE = 64;
    static final int KPLOB_WRITE_APPEND = 8192;
    static final int KPLOB_PAGE_SIZE = 16384;
    static final int KPLOB_FILE_OPEN = 256;
    static final int KPLOB_FILE_ISOPEN = 1024;
    static final int KPLOB_FILE_EXISTS = 2048;
    static final int KPLOB_FILE_CLOSE = 512;
    static final int KPLOB_OPEN = 32768;
    static final int KPLOB_CLOSE = 65536;
    static final int KPLOB_ISOPEN = 69632;
    static final int KPLOB_TMP_CREATE = 272;
    static final int KPLOB_TMP_FREE = 273;
    static final int KPLOB_GET_LEN = 1;
    static final int KPLOB_TRIM = 32;
    static final int KOKL_ORDONLY = 1;
    static final int KOKL_ORDWR = 2;
    static final int KOLF_ORDONLY = 11;
    static final byte KOLBLOPEN = 8;
    static final byte KOLBLTMP = 1;
    static final byte KOLBLRDWR = 16;
    static final byte ALLFLAGS = -1;
    static final byte KOLBLVLE = 64;
    static final int DTYCLOB = 112;
    static final int DTYBLOB = 113;
    byte[] sourceLobLocator = null;
    byte[] destinationLobLocator = null;
    long sourceOffset = 0L;
    long destinationOffset = 0L;
    int destinationLength = 0;
    short characterSet = 0;
    long lobamt = 0L;
    boolean lobnull = false;
    long lobops = 0L;
    int[] lobscn = null;
    int lobscnl = 0;
    boolean nullO2U = false;
    boolean sendLobamt = false;
    byte[] inBuffer = null;
    byte[] outBuffer = null;
    int rowsProcessed = 0;
    long lobBytesRead = 0L;
    boolean varWidthChar = false;
    boolean littleEndianClob = false;
    T4C8TTILobd lobd = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    T4C8TTILob(T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) {
        super((byte)3, 0, (short)96);
        this.setMarshalingEngine(t4CMAREngine);
        this.oer = t4CTTIoer;
        this.lobd = new T4C8TTILobd(t4CMAREngine);
    }

    boolean _close(byte[] byArray, int n) throws SQLException, IOException {
        boolean bl = true;
        if ((byArray[7] & 1) == 1) {
            if ((byArray[7] & 8) != 8) {
                DatabaseError.check_error(401);
            } else {
                byArray[7] = (byte)(byArray[7] & 0xFFFFFFE7);
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
        }
        return bl;
    }

    boolean _isOpen(byte[] byArray, int n) throws SQLException, IOException {
        boolean bl = false;
        if ((byArray[7] & 1) == 1) {
            if ((byArray[7] & 8) == 8) {
                bl = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n;
            this.nullO2U = true;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
            bl = this.lobnull;
        }
        return bl;
    }

    boolean _open(byte[] byArray, int n, int n2) throws SQLException, IOException {
        boolean bl = false;
        if ((byArray[7] & 1) == 1) {
            if ((byArray[7] & 8) == 8) {
                DatabaseError.check_error(401);
            } else {
                byArray[7] = (byte)(byArray[7] | 8);
                if (n == 2) {
                    byArray[7] = (byte)(byArray[7] | 0x10);
                }
                bl = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = byArray;
            this.lobops = n2;
            this.lobamt = n;
            this.sendLobamt = true;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
            if (this.lobamt != 0L) {
                bl = true;
            }
        }
        return bl;
    }

    abstract boolean close(byte[] var1) throws SQLException, IOException;

    abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    void freeTemporaryLob(byte[] byArray) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 273L;
        this.sourceLobLocator = byArray;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
    }

    long getChunkSize(byte[] byArray) throws SQLException, IOException {
        long l = 0L;
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = byArray;
        this.marshalFunHeader();
        this.sendLobamt = true;
        this.marshalOlobops();
        this.receiveReply();
        l = this.lobamt;
        return l;
    }

    long getLength(byte[] byArray) throws SQLException, IOException {
        long l = 0L;
        this.initializeLobdef();
        this.lobops = 1L;
        this.sourceLobLocator = byArray;
        this.sendLobamt = true;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        l = this.lobamt;
        return l;
    }

    void initializeLobdef() {
        this.sourceLobLocator = null;
        this.destinationLobLocator = null;
        this.sourceOffset = 0L;
        this.destinationOffset = 0L;
        this.destinationLength = 0;
        this.characterSet = 0;
        this.lobamt = 0L;
        this.lobnull = false;
        this.lobops = 0L;
        this.lobscn = null;
        this.lobscnl = 0;
        this.inBuffer = null;
        this.outBuffer = null;
        this.nullO2U = false;
        this.sendLobamt = false;
        this.varWidthChar = false;
        this.littleEndianClob = false;
        this.lobBytesRead = 0L;
    }

    abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    void marshalOlobops() throws IOException {
        int n = 0;
        if (this.sourceLobLocator != null) {
            n = this.sourceLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(n);
        if (this.destinationLobLocator != null) {
            this.destinationLength = this.destinationLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.destinationLength);
        if (this.meg.versionNumber >= 10000) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.sourceOffset);
        }
        if (this.meg.versionNumber >= 10000) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.destinationOffset);
        }
        if (this.characterSet != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.sendLobamt && this.meg.versionNumber < 10000) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.nullO2U) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.lobops);
        if (this.lobscnl != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.lobscnl);
        if (this.meg.versionNumber >= 10000) {
            this.meg.marshalSB8(this.sourceOffset);
            this.meg.marshalSB8(this.destinationOffset);
            if (this.sendLobamt) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
        }
        if (this.sourceLobLocator != null) {
            this.meg.marshalB1Array(this.sourceLobLocator);
        }
        if (this.destinationLobLocator != null) {
            this.meg.marshalB1Array(this.destinationLobLocator);
        }
        if (this.characterSet != 0) {
            this.meg.marshalUB2(this.characterSet);
        }
        if (this.sendLobamt && this.meg.versionNumber < 10000) {
            this.meg.marshalUB4(this.lobamt);
        }
        if (this.lobscnl != 0) {
            int n2 = 0;
            while (n2 < this.lobscnl) {
                this.meg.marshalUB4(this.lobscn[n2]);
                ++n2;
            }
        }
        if (this.sendLobamt && this.meg.versionNumber >= 10000) {
            this.meg.marshalSB8(this.lobamt);
        }
    }

    abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    long read(byte[] byArray, long l, long l2, byte[] byArray2) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l;
        this.lobamt = l2;
        this.sendLobamt = true;
        this.outBuffer = byArray2;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        return this.lobBytesRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void receiveReply() throws IOException, SQLException {
        byte by = 0;
        while (true) {
            try {
                block9: while (true) {
                    by = this.meg.unmarshalSB1();
                    switch (by) {
                        case 8: {
                            this.unmarshalTTIRPA();
                            continue block9;
                        }
                        case 14: {
                            if (!this.varWidthChar) {
                                this.lobBytesRead = this.lobd.unmarshalLobData(this.outBuffer);
                                continue block9;
                            }
                            if (this.meg.versionNumber < 10101) {
                                this.lobBytesRead = this.lobd.unmarshalClobUB2(this.outBuffer);
                                continue block9;
                            }
                            this.lobBytesRead = this.lobd.unmarshalLobData(this.outBuffer);
                            continue block9;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.rowsProcessed = this.oer.getCurRowNumber();
                            if (this.oer.getRetCode() == 1403) return;
                            this.oer.processError();
                            return;
                        }
                        default: {
                            DatabaseError.check_error(401);
                            return;
                        }
                        case 9: {
                            return;
                        }
                    }
                    break;
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
    }

    long trim(byte[] byArray, long l) throws SQLException, IOException {
        long l2 = 0L;
        this.initializeLobdef();
        this.lobops = 32L;
        this.sourceLobLocator = byArray;
        this.lobamt = l;
        this.sendLobamt = true;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        l2 = this.lobamt;
        return l2;
    }

    void unmarshalTTIRPA() throws SQLException, IOException {
        int n;
        if (this.sourceLobLocator != null) {
            n = this.sourceLobLocator.length;
            this.meg.getNBytes(this.sourceLobLocator, 0, n);
        }
        if (this.destinationLobLocator != null) {
            n = this.meg.unmarshalSB2();
            this.destinationLobLocator = this.meg.unmarshalNBytes(n);
        }
        if (this.characterSet != 0) {
            this.characterSet = this.meg.unmarshalSB2();
        }
        if (this.sendLobamt) {
            this.lobamt = this.meg.versionNumber >= 10000 ? this.meg.unmarshalSB8() : this.meg.unmarshalUB4();
        }
        if (this.nullO2U && (n = (int)this.meg.unmarshalSB2()) != 0) {
            this.lobnull = true;
        }
        if (this.lobscnl != 0) {
            n = 0;
            while (n < this.lobscnl) {
                this.lobscn[n] = this.meg.unmarshalSB4();
                ++n;
            }
        }
    }

    long write(byte[] byArray, long l, byte[] byArray2, long l2, long l3) throws SQLException, IOException {
        long l4 = 0L;
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l;
        this.lobamt = l3;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.lobd.marshalLobData(byArray2, l2, l3);
        this.receiveReply();
        l4 = this.lobamt;
        return l4;
    }
}

