/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;

public class OracleTypeINTERVAL
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1394800182554224957L;
    final int LDIINTYEARMONTH = 7;
    final int LDIINTDAYSECOND = 10;
    final int SIZE_INTERVAL_YM = 5;
    final int SIZE_INTERVAL_DS = 11;
    byte type = 0;
    int fsprec = 0;
    int lfprec = 0;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    protected OracleTypeINTERVAL() {
    }

    public OracleTypeINTERVAL(OracleConnection oracleConnection) {
    }

    public int getPrecision() throws SQLException {
        return this.lfprec;
    }

    public int getScale() throws SQLException {
        return this.fsprec;
    }

    public int getTypeCode() {
        if (this.type == 7) {
            return -103;
        }
        if (this.type == 10) {
            return -104;
        }
        return 1111;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.type = streamInfo.readByte();
        this.lfprec = streamInfo.readByte();
        this.fsprec = streamInfo.readByte();
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.type = objectInputStream.readByte();
        this.lfprec = objectInputStream.readByte();
        this.fsprec = objectInputStream.readByte();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof INTERVALYM) {
                return (INTERVALYM)object;
            }
            if (object instanceof INTERVALDS) {
                return (INTERVALDS)object;
            }
            DatabaseError.check_error(59, object);
        }
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                if (byArray.length == 5) {
                    return new INTERVALYM(byArray);
                }
                if (byArray.length != 11) break;
                return new INTERVALDS(byArray);
            }
            case 2: {
                if (byArray.length == 5) {
                    return INTERVALYM.toString(byArray);
                }
                if (byArray.length != 11) break;
                return INTERVALDS.toString(byArray);
            }
            case 3: {
                return byArray;
            }
            default: {
                DatabaseError.check_error(59);
            }
        }
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.type);
        objectOutputStream.writeByte(this.lfprec);
        objectOutputStream.writeByte(this.fsprec);
    }
}

