/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte m_uptCode = 0;
    OracleNamedType m_realType = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeUPT(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n, (Connection)oracleConnection);
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor arrayDescriptor = null;
        arrayDescriptor = !this.m_hasName ? new ArrayDescriptor((OracleTypeCOLLECTION)this.m_realType, (Connection)this.m_conn) : ArrayDescriptor.createDescriptor(this.m_fullName, this.m_conn);
        return arrayDescriptor;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor structDescriptor = null;
        structDescriptor = !this.m_hasName ? new StructDescriptor((OracleTypeADT)this.m_realType, (Connection)this.m_conn) : StructDescriptor.createDescriptor(this.m_fullName, this.m_conn);
        return structDescriptor;
    }

    public OracleType getAttrTypeAt(int n) throws SQLException {
        return ((OracleTypeADT)this.m_realType).getAttrTypeAt(n);
    }

    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.m_realType).getNumAttrs();
    }

    public OracleType getRealType() throws SQLException {
        return this.m_realType;
    }

    public int getTypeCode() throws SQLException {
        switch (this.m_uptCode) {
            case -6: {
                return this.m_realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        DatabaseError.throwSqlException(1, "Invalid type code");
        return 0;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        long l = streamInfo.readLong();
        this.m_uptCode = streamInfo.readByte();
        streamInfo.addNormalPatch(l, this.m_uptCode, this);
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = 0;
        if (datum == null) {
            n += pickleContext.writeEltNull_pctx();
        } else {
            int n2 = pickleContext.offset();
            n += pickleContext.writeLength_pctx(PickleContext.KOPI20_LN_MAXV + 1);
            int n3 = 0;
            if (this.m_uptCode == -6 && !((OracleTypeADT)this.m_realType).isFinalType()) {
                if (datum instanceof STRUCT) {
                    n3 = ((STRUCT)datum).getDescriptor().getOracleTypeADT().pickle81(pickleContext, datum);
                } else {
                    DatabaseError.throwSqlException(1, "invalid upt state");
                }
            } else {
                n3 = this.m_realType.pickle81(pickleContext, datum);
            }
            n += n3;
            pickleContext.patchImageLen_pctx(n2, n3);
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_uptCode = objectInputStream.readByte();
        this.m_realType = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.m_conn = oracleConnection;
        this.m_realType.setConnection(oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            return this.m_realType.toDatum(object, oracleConnection);
        }
        return null;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        if (object != null) {
            return this.m_realType.toDatumArray(object, oracleConnection, l, n);
        }
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        block0 : switch (n) {
            case 2: {
                switch (this.m_uptCode) {
                    case -5: {
                        if ((unpickleContext.read_byte() & 1) == 1) {
                            unpickleContext.skip_bytes(2);
                            return null;
                        }
                        return ((OracleTypeCOLLECTION)this.m_realType).unpickle80(unpickleContext, (ARRAY)null, n2 == 9 ? n2 : 3, n2, map);
                    }
                    case -6: {
                        if ((unpickleContext.read_byte() & 1) == 1) {
                            unpickleContext.skip_bytes(4);
                            return null;
                        }
                        switch (n2) {
                            case 1: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(unpickleContext, null, 3, n2, map);
                            }
                            case 2: {
                                STRUCT sTRUCT = ((OracleTypeADT)this.m_realType).unpickle80(unpickleContext, null, 1, n2, map);
                                return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                            }
                            case 9: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(unpickleContext, null, 9, 1, map);
                            }
                        }
                        DatabaseError.throwSqlException(1);
                        break block0;
                    }
                }
                DatabaseError.throwSqlException(48, "upt_type");
                break;
            }
            case 3: {
                switch (this.m_uptCode) {
                    case -5: {
                        return ((OracleTypeCOLLECTION)this.m_realType).unpickle80(unpickleContext, (ARRAY)null, n2 == 9 ? n2 : 3, n2, map);
                    }
                    case -6: {
                        switch (n2) {
                            case 1: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(unpickleContext, null, 3, n2, map);
                            }
                            case 2: {
                                STRUCT sTRUCT = ((OracleTypeADT)this.m_realType).unpickle80(unpickleContext, null, 1, n2, map);
                                return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                            }
                            case 9: {
                                return ((OracleTypeADT)this.m_realType).unpickle80(unpickleContext, null, 9, 1, map);
                            }
                        }
                        DatabaseError.throwSqlException(1);
                        break block0;
                    }
                }
                DatabaseError.throwSqlException(48, "upt_type");
                break;
            }
            case 1: {
                switch (this.m_uptCode) {
                    case -5: {
                        if (unpickleContext.is_null(this.null_offset)) {
                            unpickleContext.skip_bytes(4);
                            return null;
                        }
                        unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
                        if (n2 == 9) {
                            unpickleContext.skip_bytes(4);
                            return null;
                        }
                        unpickleContext.markAndSkip();
                        ARRAY aRRAY = ((OracleTypeCOLLECTION)this.m_realType).unpickle80(unpickleContext, (ARRAY)null, 3, n2, map);
                        unpickleContext.reset();
                        return aRRAY;
                    }
                }
                DatabaseError.throwSqlException(1, "upt_type");
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "upt_type");
            }
        }
        return null;
    }

    private Object unpickle81UPT(PickleContext pickleContext, int n, Map map) throws SQLException {
        switch (this.m_uptCode) {
            case -6: {
                switch (n) {
                    case 1: {
                        return ((OracleTypeADT)this.m_realType).unpickle81(pickleContext, null, 3, n, map);
                    }
                    case 2: {
                        STRUCT sTRUCT = ((OracleTypeADT)this.m_realType).unpickle81(pickleContext, null, 1, n, map);
                        return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.m_realType).unpickle81(pickleContext, null, 9, 1, map);
                    }
                }
                DatabaseError.throwSqlException(1);
                break;
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.m_realType).unpickle81(pickleContext, (ARRAY)null, n == 9 ? n : 3, n, map);
            }
            case 58: {
                return ((OracleTypeOPAQUE)this.m_realType).unpickle81(pickleContext, null, n == 9 ? n : 3, map);
            }
            default: {
                DatabaseError.throwSqlException(1, "Unrecognized UPT code");
            }
        }
        return null;
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n, Map map) throws SQLException {
        long l = pickleContext.readRestOfLength_pctx(by);
        if (n == 9) {
            pickleContext.skip_bytes((int)l);
            return null;
        }
        return this.unpickle81UPT(pickleContext, n, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n, Map map) throws SQLException {
        OracleLog.print(this, 16, 8, 32, "OracleTypeUPT.unpickle81rec(" + pickleContext + ") " + this.m_fullName);
        byte by = pickleContext.readByte_pctx();
        if (PickleContext.isElementNull_pctx(by)) {
            return null;
        }
        if (n == 9) {
            pickleContext.skip_bytes(pickleContext.readRestOfLength_pctx(by));
            return null;
        }
        pickleContext.skipRestOfLength_pctx(by);
        return this.unpickle81UPT(pickleContext, n, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.m_uptCode);
        objectOutputStream.writeObject(this.m_realType);
    }
}

