/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;

public class SQLName
implements Serializable {
    static boolean DEBUG = false;
    static boolean s_parseAllFormat = false;
    static final long serialVersionUID = 2266340348729491526L;
    String name;
    String schema;
    String simple;
    int version;
    boolean synonym;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    protected SQLName() {
    }

    protected SQLName(String string, String string2, OracleConnection oracleConnection) throws SQLException {
        this.schema = string;
        this.simple = string2;
        this.name = String.valueOf(this.schema) + "." + this.simple;
        this.version = 2;
        this.synonym = false;
    }

    public SQLName(String string, OracleConnection oracleConnection) throws SQLException {
        this.init(string, oracleConnection);
        this.version = 2;
        this.synonym = false;
    }

    public static boolean getHandleDoubleQuote() throws SQLException {
        return s_parseAllFormat;
    }

    public String getName() throws SQLException {
        return this.name;
    }

    public String getSchema() throws SQLException {
        return this.schema;
    }

    public String getSimpleName() throws SQLException {
        return this.simple;
    }

    public int getVersion() throws SQLException {
        return this.version;
    }

    private void init(String string, OracleConnection oracleConnection) throws SQLException {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        if (SQLName.parse(string, stringArray, stringArray2, true)) {
            this.schema = stringArray[0];
            this.simple = stringArray2[0];
        } else {
            this.schema = oracleConnection.getUserName();
            this.simple = stringArray2[0];
        }
        this.name = String.valueOf(this.schema) + "." + this.simple;
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) throws SQLException {
        return SQLName.parse(string, stringArray, stringArray2, s_parseAllFormat);
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2, boolean bl) throws SQLException {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < 1 || stringArray2 == null || stringArray2.length < 1) {
            DatabaseError.throwSqlException(68);
        }
        if (!bl) {
            int n = string.indexOf(".");
            if (n < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n);
            stringArray2[0] = string.substring(n + 1);
            return true;
        }
        int n = string.length();
        int n2 = string.indexOf("\"");
        int n3 = string.indexOf("\"", n2 + 1);
        int n4 = -1;
        if (n2 < 0) {
            n4 = string.indexOf(".");
            if (n4 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n4);
            stringArray2[0] = string.substring(n4 + 1);
            return true;
        }
        if (n2 == 0) {
            if (n3 == n - 1) {
                stringArray2[0] = string.substring(n2 + 1, n3);
                return false;
            }
            n4 = string.indexOf(".", n3);
            stringArray[0] = string.substring(n2 + 1, n3);
            n2 = string.indexOf("\"", n4);
            n3 = string.indexOf("\"", n2 + 1);
            if (n2 < 0) {
                stringArray2[0] = string.substring(n4 + 1);
                return true;
            }
            stringArray2[0] = string.substring(n2 + 1, n3);
            return true;
        }
        n4 = string.indexOf(".");
        stringArray[0] = string.substring(0, n4);
        stringArray2[0] = string.substring(n2 + 1, n3);
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.schema = objectInputStream.readUTF();
        this.simple = objectInputStream.readUTF();
        this.version = objectInputStream.readInt();
        this.synonym = objectInputStream.readBoolean();
    }

    public static void setHandleDoubleQuote(boolean bl) throws SQLException {
        s_parseAllFormat = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeUTF(this.schema);
        objectOutputStream.writeUTF(this.simple);
        objectOutputStream.writeInt(this.version);
        objectOutputStream.writeBoolean(this.synonym);
    }
}

