/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.struts;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;

public abstract class GenericFilterForm
extends ActionForm {
    private static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    protected SimpleDateFormat filterDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    protected Integer defaultDuration;
    protected Date startDate;
    protected Date endDate;
    protected String wildcard;

    public abstract Date defaultStartDate();

    public abstract Date defaultEndDate();

    public abstract Integer defaultDuration();

    public abstract String[][] getReportDisplay();

    public GenericFilterForm() {
        this.resetFilter();
    }

    public void resetFilter() {
        this.startDate = this.defaultStartDate();
        this.endDate = this.defaultEndDate();
        this.wildcard = null;
        this.defaultDuration = this.defaultDuration();
    }

    public void turnOffDates() {
        this.startDate = null;
        this.endDate = null;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void setDateFormat(String string) {
        this.filterDateFormat = new SimpleDateFormat(string);
    }

    public String getEndDate() {
        return this.endDate == null ? "" : this.filterDateFormat.format(this.endDate);
    }

    public Date startDate() {
        return this.startDate;
    }

    public String getStartDate() {
        return this.startDate == null ? "" : this.filterDateFormat.format(this.startDate);
    }

    public void setNumDays(int n) {
        try {
            this.defaultDuration = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.defaultDuration = null;
        }
    }

    public void setNumDays(String string) {
        try {
            this.defaultDuration = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.defaultDuration = null;
        }
    }

    public String getNumDays() {
        return this.defaultDuration == null ? "" : this.defaultDuration.toString();
    }

    public String getWildcard() {
        return this.wildcard == null ? "" : this.wildcard;
    }

    public void setWildcard(String string) {
        this.wildcard = string;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public void setEndDate(String string) {
        try {
            this.endDate = this.filterDateFormat.parse(string);
        }
        catch (Exception exception) {
            this.endDate = null;
        }
    }

    public void setNumDays(Integer n) {
        this.defaultDuration = n;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public void setStartDate(String string) {
        try {
            this.startDate = this.filterDateFormat.parse(string);
        }
        catch (Exception exception) {
            this.startDate = null;
        }
    }

    public void validateDates(ActionErrors actionErrors, String string, String string2) {
        if (this.startDate != null && this.endDate != null && this.startDate.after(this.endDate)) {
            actionErrors.add(string, new ActionError("error.filter.startAfterEnd"));
        }
    }
}

