/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.xml;

import com.n2bb.commons.xml.PrettyXML;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XMLUtil {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected static Log n2bbLog = LogFactory.getLog((Class)(class$com$n2bb$commons$xml$XMLUtil == null ? (class$com$n2bb$commons$xml$XMLUtil = XMLUtil.class$("com.n2bb.commons.xml.XMLUtil")) : class$com$n2bb$commons$xml$XMLUtil));
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static boolean DEBUG = false;
    static /* synthetic */ Class class$com$n2bb$commons$xml$XMLUtil;

    private XMLUtil() {
    }

    private static void init() {
        try {
            if (documentBuilderFactory == null) {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
        }
        catch (Exception exception) {
            n2bbLog.error((Object)"!!!XMLUtil static() Error instantiating DocumentBuilderFactory.", (Throwable)exception);
        }
    }

    public static Document newDocument() throws Exception {
        XMLUtil.init();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public static Document parseFile(File file) throws Exception {
        try {
            XMLUtil.init();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)("!!!XMLUtil parseFile() Error retrieving DOM from path=" + file.getAbsolutePath()), (Throwable)exception);
            throw exception;
        }
    }

    public static Document parseStream(InputStream inputStream) throws Exception {
        try {
            XMLUtil.init();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)("!!!XMLUtil parseFile() Error retrieving DOM from stream=" + inputStream.getClass().getName()), (Throwable)exception);
            throw exception;
        }
    }

    public static Document parsePath(String string) throws Exception {
        XMLUtil.init();
        File file = new File(string);
        n2bbLog.debug((Object)("File exists=" + file.exists()));
        return XMLUtil.parseFile(file);
    }

    public static void serializeDocument(Document document, String string) {
        XMLUtil.serializeDocument(document, string, DEFAULT_ENCODING);
    }

    public static void serializeDocument(Document document, String string, String string2) {
        try {
            XMLUtil.init();
            File file = new File(string);
            n2bbLog.debug((Object)("XMLUTIL writing to=" + file.getAbsolutePath()));
            PrettyXML.prettyXML(document, file, string2);
        }
        catch (Exception exception) {
            n2bbLog.error((Object)"!!!XMLUTIL Save() EXCEPTION", (Throwable)exception);
        }
    }

    public static byte[] serializeDocument(Document document) {
        try {
            XMLUtil.init();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "no");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            if (DEBUG) {
                n2bbLog.debug((Object)("DOCUMENT:\n" + new String(byteArrayOutputStream.toByteArray()) + "\nencodedDocument End."));
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            n2bbLog.error((Object)"!!!XMLUtil serializeDocument() Error serializing doc to byte[]");
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

