/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.consumers;

import com.n2bb.AlertsModule.util.MessageQueue;
import com.n2bb.AlertsModule.util.UDPListener;
import com.n2bb.LogModule.N2BB_LogClient;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class UDPConsumerBase {
    protected static Logger log = Logger.getLogger(UDPConsumerBase.class);
    protected MessageQueue messageQueue;
    private Thread listener;
    private Vector consumers;

    public UDPConsumerBase(int listenPort, int rcvBufferSize, int consumerThreads) throws Exception {
        log.info((Object)("UDP listen port... " + listenPort));
        log.info((Object)("consumer threads... " + consumerThreads));
        this.messageQueue = new MessageQueue();
        this.listener = new UDPListener(listenPort, this.messageQueue, rcvBufferSize);
        this.listener.start();
        this.initConsumers(consumerThreads);
    }

    private void initConsumers(int consumerThreads) throws Exception {
        this.consumers = new Vector();
        try {
            for (int i = 0; i < consumerThreads; ++i) {
                ConsumerThread consumerThread = new ConsumerThread();
                consumerThread.start();
                this.consumers.add(consumerThread);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected abstract void processMessage(Object[] var1) throws Exception;

    private class ConsumerThread
    extends Thread {
        private ConsumerThread() {
        }

        public void run() {
            log.info((Object)"consumer thread starting");
            while (true) {
                try {
                    while (true) {
                        UDPConsumerBase.this.processMessage((Object[])UDPConsumerBase.this.messageQueue.getMessage());
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    N2BB_LogClient.instance().logStackTrace("AlertServer", "ConsumerThread.run", "exception", (Throwable)e, 3);
                    continue;
                }
                break;
            }
        }
    }
}

