/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class ArrayDataResultSet
extends BaseResultSet {
    Datum[] m_data;
    Map m_map;
    private int m_idx;
    private int m_lastIdx;
    boolean m_closed;
    PhysicalConnection m_conn;
    private Boolean m_wasNull;
    private static Boolean BOOLEAN_TRUE = new Boolean(true);
    private static Boolean BOOLEAN_FALSE = new Boolean(false);
    private int m_fetchSz;
    ARRAY m_array;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public ArrayDataResultSet(OracleConnection oracleConnection, ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        this.m_conn = (PhysicalConnection)oracleConnection;
        this.m_array = aRRAY;
        this.m_map = map;
        this.m_idx = (int)l - 1;
        int n2 = this.m_array == null ? 0 : aRRAY.length();
        this.m_lastIdx = this.m_idx + (n == -1 ? n2 - this.m_idx : Math.min(n2 - this.m_idx, n));
        this.m_fetchSz = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, long l, int n, Map map) throws SQLException {
        this.m_conn = (PhysicalConnection)oracleConnection;
        this.m_data = datumArray;
        this.m_map = map;
        this.m_idx = (int)l - 1;
        int n2 = this.m_data == null ? 0 : this.m_data.length;
        this.m_lastIdx = this.m_idx + Math.min(n2 - this.m_idx, n);
        this.m_fetchSz = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, Map map) throws SQLException {
        this.m_conn = (PhysicalConnection)oracleConnection;
        this.m_data = datumArray;
        this.m_map = map;
        this.m_idx = 0;
        this.m_lastIdx = this.m_data == null ? 0 : this.m_data.length;
        this.m_fetchSz = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public synchronized void close() throws SQLException {
        this.m_closed = true;
    }

    public synchronized int findColumn(String string) throws SQLException {
        if (string.equalsIgnoreCase("index")) {
            return 1;
        }
        if (string.equalsIgnoreCase("value")) {
            return 2;
        }
        DatabaseError.check_error(6, "get_column_index");
        return 0;
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DatabaseError.check_error(4, "getARRAY");
        }
        return null;
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DatabaseError.check_error(4, "getBFILE");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DatabaseError.check_error(4, "getBLOB");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DatabaseError.check_error(4, "getBytes");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DatabaseError.check_error(4, "getCHAR");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DatabaseError.check_error(4, "getCLOB");
        }
        return null;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        DatabaseError.check_error(4, "getCursor");
        return null;
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DatabaseError.check_error(4, "getDATE");
        }
        return null;
    }

    public synchronized Date getDate(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DATE dATE = null;
            dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dATE != null) {
                return dATE.dateValue(calendar);
            }
        }
        return null;
    }

    public synchronized double getDouble(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSz;
    }

    public synchronized float getFloat(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized int getInt(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    public synchronized long getLong(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.m_closed) {
            DatabaseError.check_error(10, "getMetaData");
        }
        DatabaseError.check_error(23, "getMetaData");
        return null;
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DatabaseError.check_error(4, "getNUMBER");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DatabaseError.check_error(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return oRADataFactory.create(datum, 0);
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.getObject(n, this.m_map);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        if (this.m_idx <= 0) {
            DatabaseError.check_error(14, null);
        }
        if (n == 1) {
            this.m_wasNull = BOOLEAN_FALSE;
            return new NUMBER(this.m_idx);
        }
        if (n == 2) {
            Datum[] datumArray;
            if (this.m_data != null) {
                this.m_wasNull = this.m_data[this.m_idx - 1] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return this.m_data[this.m_idx - 1];
            }
            if (this.m_array != null && (datumArray = this.m_array.getOracleArray(this.m_idx, 1)) != null && datumArray.length >= 1) {
                this.m_wasNull = datumArray[0] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return datumArray[0];
            }
            DatabaseError.check_error(1, "Out of sync");
        }
        DatabaseError.check_error(3, null);
        return null;
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DatabaseError.check_error(4, "getRAW");
        }
        return null;
    }

    public synchronized REF getREF(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DatabaseError.check_error(4, "getREF");
        }
        return null;
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DatabaseError.check_error(4, "getROWID");
        }
        return null;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public int getRow() throws SQLException {
        return this.m_idx;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DatabaseError.check_error(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized short getShort(int n) throws SQLException {
        long l = this.getLong(n);
        if (l > 65537L || l < -65538L) {
            DatabaseError.check_error(26, "getShort");
        }
        return (short)l;
    }

    public synchronized Statement getStatement() throws SQLException {
        return null;
    }

    public synchronized String getString(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized Time getTime(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DATE dATE = null;
            dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dATE != null) {
                return dATE.timeValue(calendar);
            }
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DATE dATE = null;
            dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dATE != null) {
                return dATE.timestampValue(calendar);
            }
        }
        return null;
    }

    public synchronized URL getURL(int n) throws SQLException {
        throw new SQLException("Conversion to java.net.URL not supported.");
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        Datum datum = this.getOracleObject(n);
        if (datum != null) {
            DBConversion dBConversion = this.m_conn.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DatabaseError.check_error(4, "getUnicodeStream");
        }
        return null;
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_idx > this.m_lastIdx;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.m_idx < 1;
    }

    public boolean isFirst() throws SQLException {
        return this.m_idx == 1;
    }

    public boolean isLast() throws SQLException {
        return this.m_idx == this.m_lastIdx;
    }

    public boolean next() throws SQLException {
        if (this.m_closed) {
            DatabaseError.check_error(10, "next");
        }
        ++this.m_idx;
        return this.m_idx <= this.m_lastIdx;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        } else {
            this.m_fetchSz = n == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n;
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.m_wasNull == null) {
            DatabaseError.check_error(24, null);
        }
        return this.m_wasNull;
    }
}

