/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawCommonAccessor;

class LongRawAccessor
extends RawCommonAccessor {
    OracleInputStream stream;
    int column_position = 0;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    LongRawAccessor(OracleStatement oracleStatement, int n, int n2, short s, int n3) throws SQLException {
        this.init(oracleStatement, 24, 24, s, false);
        this.column_position = n;
        this.initForDataAccess(n3, n2, null);
    }

    LongRawAccessor(OracleStatement oracleStatement, int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s) throws SQLException {
        this.init(oracleStatement, 24, 24, s, false);
        this.column_position = n;
        this.initForDescribe(24, n2, bl, n3, n4, n5, n6, n7, s, null);
        int n8 = oracleStatement.max_field_size;
        if (n8 > 0 && (n2 == 0 || n8 < n2)) {
            n2 = n8;
        }
        this.initForDataAccess(0, n2, null);
    }

    InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1 && this.stream != null) {
            if (this.stream.closed) {
                DatabaseError.throwSqlException(27);
            }
            PhysicalConnection physicalConnection = this.stmt.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 2);
        }
        return inputStream;
    }

    InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1 && this.stream != null) {
            if (this.stream.closed) {
                DatabaseError.throwSqlException(27);
            }
            PhysicalConnection physicalConnection = this.stmt.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 6);
        }
        return inputStream;
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1 && this.stream != null) {
            if (this.stream.closed) {
                DatabaseError.throwSqlException(27);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray2 = new byte[1024];
            try {
                int n2;
                while ((n2 = this.stream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1 && this.stream != null) {
            if (this.stream.closed) {
                DatabaseError.throwSqlException(27);
            }
            PhysicalConnection physicalConnection = this.stmt.connection;
            reader = physicalConnection.conversion.ConvertCharacterStream(this.stream, 8);
        }
        return reader;
    }

    InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1 && this.stream != null) {
            if (this.stream.closed) {
                DatabaseError.throwSqlException(27);
            }
            PhysicalConnection physicalConnection = this.stmt.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 3);
        }
        return inputStream;
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.is_stream = true;
        this.isColumnNumberAware = true;
        this.t_max_length = Integer.MAX_VALUE;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
        this.byteLength = 0;
        this.stream = this.stmt.connection.driverExtension.createInputStream(this.stmt, this.column_position, this);
    }

    OracleInputStream initForNewRow() throws SQLException {
        this.stream = this.stmt.connection.driverExtension.createInputStream(this.stmt, this.column_position, this);
        return this.stream;
    }

    public String toString() {
        return "LongRawAccessor@" + Integer.toHexString(this.hashCode()) + "{column_position = " + this.column_position + "}";
    }

    void updateColumnNumber(int n) {
        this.column_position = ++n;
        if (this.stream != null) {
            this.stream.columnIndex = n;
        }
    }
}

