/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements ConnectionPoolDataSource {
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public OracleConnectionPoolDataSource() throws SQLException {
        this.m_dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
        this.m_connCachingEnabled = false;
        this.m_fastConnFailover = false;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.m_user, this.m_password);
    }

    protected Connection getPhysicalConnection(String string, String string2) throws SQLException {
        return super.getConnection(string, string2);
    }

    protected Connection getPhysicalConnection(String string, String string2, String string3) throws SQLException {
        this.m_url = string;
        return super.getConnection(string2, string3);
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.m_user, this.m_password);
    }

    public synchronized PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Connection connection = this.getPhysicalConnection(this.m_url, string, string2);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        oraclePooledConnection.m_pcUser = string.toLowerCase();
        return oraclePooledConnection;
    }
}

