/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXADataSource;

public class OracleXAConnectionCacheImpl
extends OracleConnectionCacheImpl
implements XADataSource,
Serializable {
    private boolean m_nativeXA = false;
    private static final String clientXADS = "oracle.jdbc.xa.client.OracleXADataSource";
    private static final String serverXADS = "oracle.jdbc.xa.server.OracleXADataSource";
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public OracleXAConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleXAConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        super(connectionPoolDataSource);
        this.m_dataSourceName = "OracleXAConnectionCacheImpl";
    }

    public synchronized void closeActualConnection(PooledConnection pooledConnection) throws SQLException {
        ((OracleXAConnection)pooledConnection).close();
    }

    public synchronized boolean getNativeXA() {
        return this.m_nativeXA;
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        Object object;
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DatabaseError.throwSqlException(79);
            }
            object = null;
            object = OracleDriver.getSystemProperty("oracle.jserver.version") == null ? clientXADS : serverXADS;
            try {
                this.m_cpds = (OracleXADataSource)Class.forName((String)object).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DatabaseError.throwSqlException(1);
            }
            this.copy((OracleDataSource)((Object)this.m_cpds));
            ((OracleXADataSource)this.m_cpds).setNativeXA(this.m_nativeXA);
        }
        object = ((OracleXADataSource)this.m_cpds).getXAConnection();
        ((OracleXAConnection)object).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        return object;
    }

    public synchronized XAConnection getXAConnection() throws SQLException {
        XAConnection xAConnection = (XAConnection)super.getPooledConnection(this.m_user, this.m_password);
        return xAConnection;
    }

    public synchronized XAConnection getXAConnection(String string, String string2) throws SQLException {
        XAConnection xAConnection = (XAConnection)super.getPooledConnection(string, string2);
        return xAConnection;
    }

    public synchronized void setNativeXA(boolean bl) {
        this.m_nativeXA = bl;
    }
}

