/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose = false;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
        }
        catch (SQLException sQLException) {}
        if (this.m_version < 8170) {
            throw new XAException(-6);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n = -1;
        boolean bl2 = false;
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = bl ? 1 : 0;
        Xid xid2 = super.suspendStacked(xid);
        n = this.do_commit(xid, n2);
        super.resumeStacked(xid2);
        this.checkError(n);
    }

    public void doTwoPhaseAction(int n, int n2, String[] stringArray, Xid[] xidArray) throws XAException {
        this.do_doTwoPhaseAction(n, n2, stringArray, xidArray);
    }

    protected int do_commit(Xid xid, int n) throws XAException {
        int n2 = -1;
        CallableStatement callableStatement = null;
        boolean bl = false;
        try {
            block9: {
                try {
                    callableStatement = this.m_conn.prepareCall(xa_commit_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.setInt(5, n);
                    callableStatement.execute();
                    n2 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n2;
    }

    protected int do_doTwoPhaseAction(int n, int n2, String[] stringArray, Xid[] xidArray) throws XAException {
        throw new XAException(-6);
    }

    protected int do_end(Xid xid, int n) throws XAException {
        CallableStatement callableStatement = null;
        int n2 = -1;
        try {
            block9: {
                try {
                    callableStatement = this.m_conn.prepareCall(xa_end_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.setInt(5, n);
                    callableStatement.execute();
                    n2 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n2;
    }

    protected int do_forget(Xid xid) throws XAException {
        int n = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    this.saveTxnMode();
                    callableStatement = this.m_conn.prepareCall(xa_forget_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.execute();
                    n = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            this.restoreTxnMode();
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.restoreTxnMode();
        return n;
    }

    protected int do_prepare(Xid xid) throws XAException {
        int n = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.m_conn.prepareCall(xa_prepare_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.execute();
                    n = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n;
    }

    protected int do_rollback(Xid xid) throws XAException {
        int n = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.m_conn.prepareCall(xa_rollback_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.execute();
                    n = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n;
    }

    protected int do_start(Xid xid, int n) throws XAException {
        int n2 = -1;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.m_conn.prepareCall(xa_start_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.setInt(5, this.m_timeout);
                    callableStatement.setInt(6, n);
                    callableStatement.execute();
                    n2 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n2;
    }

    public void end(Xid xid, int n) throws XAException {
        int n2 = -1;
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000 && (n & 2) != 2) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid, n);
            super.pop();
            n2 = this.do_end(xid, n);
            super.resumeStacked(xid2);
            this.checkError(n2);
        }
        finally {
            Object var5_5 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    public void forget(Xid xid) throws XAException {
        int n = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        n = this.do_forget(xid);
        this.checkError(n);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        int n2 = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        Xid xid2 = super.suspendStacked(xid);
        n2 = this.do_prepare(xid);
        super.resumeStacked(xid2);
        int n3 = n = n2 == 0 ? 0 : OracleXAException.errorConvert(n2);
        if (n != 0 && n != 3) {
            throw new OracleXAException(n2);
        }
        return n;
    }

    public void rollback(Xid xid) throws XAException {
        int n = 0;
        boolean bl = false;
        if (xid == null) {
            throw new XAException(-5);
        }
        Xid xid2 = super.suspendStacked(xid);
        n = this.do_rollback(xid);
        super.resumeStacked(xid2);
        this.checkError(n);
    }

    public void start(Xid xid, int n) throws XAException {
        int n2 = -1;
        Object var4_4 = null;
        try {
            this.disallowLocalTxnMode(-6);
            if (xid == null) {
                throw new XAException(-5);
            }
            int n3 = n & 0xFF00;
            int n4 = (n &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
            if ((n &= 0xFFFEFFFF) != 0 && n != 0x8000000 && n != 0x200000 && n != 2 || n4 != 0 && (n4 & 0x10000) != 65536) {
                throw new XAException(-5);
            }
            if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
                throw new XAException(-5);
            }
            if ((n & 0x8200000) != 0 && ((n3 & 0xFF00) != 0 || (n4 & 0x10000) != 0)) {
                throw new XAException(-5);
            }
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            n2 = this.do_start(xid, n |= n3 | n4);
            this.checkError(n2);
            super.push(xid);
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }
}

