/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class Util {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public static Object _convertToObject(Datum datum, int n, Object object) throws SQLException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof STRUCT) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2002);
            }
            return ((CustomDatumFactory)object).create(datum, 2002);
        }
        if (datum instanceof REF) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2006);
            }
            return ((CustomDatumFactory)object).create(datum, 2006);
        }
        if (datum instanceof ARRAY) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2003);
            }
            return ((CustomDatumFactory)object).create(datum, 2003);
        }
        if (datum instanceof OPAQUE) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2007);
            }
            return ((CustomDatumFactory)object).create(datum, 2007);
        }
        if (object != null) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, n);
            }
            return ((CustomDatumFactory)object).create(datum, n);
        }
        if (datum instanceof NUMBER) {
            if (n == 2 || n == 3) {
                return ((NUMBER)datum).bigDecimalValue();
            }
            if (n == 8 || n == 6) {
                return new Double(((NUMBER)datum).doubleValue());
            }
            if (n == 4 || n == 5) {
                return new Integer(((NUMBER)datum).intValue());
            }
            if (n == 7) {
                return new Float(((NUMBER)datum).floatValue());
            }
            if (n == 16) {
                return new Boolean(((NUMBER)datum).booleanValue());
            }
            throw new SQLException("Unexpected java.sql.OracleTypes type: " + n);
        }
        return datum.toJdbc();
    }

    private static Datum _convertToOracle(Object object, Connection connection) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof ORAData) {
            return ((ORAData)object).toDatum(connection);
        }
        if (object instanceof CustomDatum) {
            return ((CustomDatum)object).toDatum((OracleConnection)connection);
        }
        if (object instanceof String) {
            short s;
            short s2 = s = connection == null || !(connection instanceof OracleConnection) ? (short)870 : (short)((OracleConnection)connection).getDbCsId();
            if (s != lastCsId) {
                lastCsId = s;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)object, lastCS);
        }
        if (object instanceof Character) {
            short s;
            short s3 = s = connection == null || !(connection instanceof OracleConnection) ? (short)870 : (short)((OracleConnection)connection).getDbCsId();
            if (s != lastCsId) {
                lastCsId = s;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)object).toString(), lastCS);
        }
        if (object instanceof BigDecimal) {
            return new NUMBER((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new NUMBER((BigInteger)object);
        }
        if (object instanceof Double) {
            return new NUMBER((Double)object);
        }
        if (object instanceof Float) {
            return new NUMBER(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new NUMBER((Integer)object);
        }
        if (object instanceof Boolean) {
            return new NUMBER((Boolean)object);
        }
        if (object instanceof Short) {
            return new NUMBER((Short)object);
        }
        if (object instanceof Byte) {
            return new NUMBER((Byte)object);
        }
        if (object instanceof Long) {
            return new NUMBER((Long)object);
        }
        if (object instanceof Timestamp) {
            return new DATE((Timestamp)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)object).getTime()));
        }
        if (object instanceof byte[]) {
            return new RAW((byte[])object);
        }
        if (object instanceof Datum) {
            return (Datum)object;
        }
        throw new SQLException("Unable to convert object to oracle.sql.Datum: " + object);
    }

    public static Object convertToObject(Datum datum, int n, Object object) throws SQLException {
        Object object2 = Util._convertToObject(datum, n, object);
        return object2;
    }

    public static Datum convertToOracle(Object object, Connection connection) throws SQLException {
        Datum datum = Util._convertToOracle(object, connection);
        return datum;
    }

    static boolean isMutable(Datum datum, CustomDatumFactory customDatumFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || datum instanceof STRUCT && customDatumFactory != null || datum instanceof OPAQUE && customDatumFactory != null || datum instanceof ARRAY && customDatumFactory != null;
    }

    static boolean isMutable(Datum datum, ORADataFactory oRADataFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || datum instanceof STRUCT && oRADataFactory != null || datum instanceof OPAQUE && oRADataFactory != null || datum instanceof ARRAY && oRADataFactory != null;
    }
}

