/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public DatumWithConnection() {
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
    }

    public static void assertNotNull(Connection connection) throws SQLException {
        if (connection == null) {
            DatabaseError.check_error(68, "Connection is null");
        }
    }

    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        if (typeDescriptor == null) {
            DatabaseError.check_error(61);
        }
    }

    public OracleConnection getConnection() throws SQLException {
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)this.physicalConnection;
        }
        catch (ClassCastException classCastException) {
            DatabaseError.throwSqlException(103);
        }
        return oracleConnection;
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.getPhysicalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        block2: {
            if (this.physicalConnection != null) break block2;
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {}
        }
        return this.physicalConnection;
    }

    public void setPhysicalConnectionOf(Connection connection) {
        this.physicalConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
    }
}

