/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.data;

import com.n2bb.commons.data.ValidatedObject;
import com.n2bb.commons.exceptions.DataFormatException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class CableLabsDate
extends GregorianCalendar
implements Comparable,
Cloneable,
Serializable,
ValidatedObject {
    public static final String LONG_PATTERN = "yyyy-MM-dd'T'hh:mm:ss";
    private static final SimpleDateFormat LONG_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    public static final String MEDIUM_PATTERN = "yyyy-MM-dd'T'hh:mm";
    private static final SimpleDateFormat MEDIUM_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm");
    public static final String SHORT_PATTERN = "yyyy-MM-dd";
    private static final SimpleDateFormat SHORT_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat format;

    private CableLabsDate(Date date, SimpleDateFormat simpleDateFormat) {
        super(TimeZone.getDefault(), Locale.getDefault());
        super.setTime(date);
        super.setLenient(false);
        this.format = simpleDateFormat;
    }

    public CableLabsDate(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        super.setLenient(false);
        this.format = LONG_FORMAT;
    }

    public static CableLabsDate getLong(Date date) {
        return new CableLabsDate(date, LONG_FORMAT);
    }

    public static CableLabsDate getMedium(Date date) {
        return new CableLabsDate(date, MEDIUM_FORMAT);
    }

    public static CableLabsDate getShort(Date date) {
        return new CableLabsDate(date, SHORT_FORMAT);
    }

    public static CableLabsDate parse(String string) throws DataFormatException, ParseException {
        CableLabsDate cableLabsDate;
        if (string == null) {
            throw new DataFormatException("Date String cannot be <NULL>");
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        if (stringBuffer.length() > 16) {
            Date date = LONG_FORMAT.parse(stringBuffer.toString());
            cableLabsDate = new CableLabsDate(date, LONG_FORMAT);
        } else if (stringBuffer.length() == 16) {
            Date date = MEDIUM_FORMAT.parse(stringBuffer.toString());
            cableLabsDate = new CableLabsDate(date, MEDIUM_FORMAT);
        } else {
            Date date = SHORT_FORMAT.parse(stringBuffer.toString());
            cableLabsDate = new CableLabsDate(date, SHORT_FORMAT);
        }
        return cableLabsDate;
    }

    public String getFormattedTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss");
        return simpleDateFormat.format(this.getTime());
    }

    public String getFormattedLong() {
        return LONG_FORMAT.format(this.getTime());
    }

    public String getFormattedMedium() {
        return MEDIUM_FORMAT.format(this.getTime());
    }

    public String getFormattedShort() {
        return SHORT_FORMAT.format(this.getTime());
    }

    public String getFormatted() {
        return this.format.format(this.getTime());
    }

    public void setTime(int n, int n2, int n3) {
        super.set(11, n);
        super.set(12, n2);
        super.set(13, n3);
    }

    public String getFormat() {
        return this.format.toPattern();
    }

    public int compareTo(Object object) {
        Calendar calendar = (Calendar)object;
        if (this.getTime().after(calendar.getTime())) {
            return 1;
        }
        if (this.getTime().before(calendar.getTime())) {
            return -1;
        }
        return 0;
    }

    public boolean equals(CableLabsDate cableLabsDate) {
        return this.getTime().equals(cableLabsDate.getTime());
    }

    public boolean validate() {
        return true;
    }

    public boolean isShort() {
        return this.format.toPattern().equals(SHORT_PATTERN);
    }

    public boolean isLong() {
        return this.format.toPattern().equals(LONG_PATTERN);
    }

    public boolean isMedium() {
        return this.format.toPattern().equals(MEDIUM_PATTERN);
    }

    public String toString() {
        return this.getFormatted();
    }

    public Object clone() {
        try {
            return CableLabsDate.parse(this.getFormatted());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            CableLabsDate cableLabsDate = CableLabsDate.parse("2004-04-11");
            System.out.println(cableLabsDate.getFormattedShort());
            System.out.println(cableLabsDate.getFormattedMedium());
            System.out.println(cableLabsDate.getFormattedLong());
            System.out.println(cableLabsDate.getFormattedTime());
            System.out.println("-------------------");
            cableLabsDate = CableLabsDate.parse("2004-04-11T12:59");
            System.out.println(cableLabsDate.getFormattedShort());
            System.out.println(cableLabsDate.getFormattedMedium());
            System.out.println(cableLabsDate.getFormattedLong());
            System.out.println(cableLabsDate.getFormattedTime());
            System.out.println("-------------------");
            cableLabsDate = CableLabsDate.parse("2004-04-11T12:59:01");
            System.out.println(cableLabsDate.getFormattedShort());
            System.out.println(cableLabsDate.getFormattedMedium());
            System.out.println(cableLabsDate.getFormattedLong());
            System.out.println(cableLabsDate.getFormattedTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

