/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.debug;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathVerifier {
    private static void makeClassEntry(String string, String string2, Map map) {
        Collection<String> collection = null;
        if (map.containsKey(string2)) {
            collection = (Collection)map.get(string2);
            collection.add(string);
        } else {
            collection = new ArrayList();
            collection.add(string);
        }
        map.put(string2, collection);
    }

    private static boolean matchesAnyPatterns(String string, Pattern[] patternArray) {
        boolean bl = false;
        for (int i = 0; !bl && i < patternArray.length; ++i) {
            if (!patternArray[i].matcher(string).matches()) continue;
            bl = true;
        }
        return bl;
    }

    private static Map getZipClassMap(String string, Map map, Pattern[] patternArray) throws Exception {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || ClasspathVerifier.matchesAnyPatterns(zipEntry.getName(), patternArray)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(zipEntry.getName(), "/");
            boolean bl = true;
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (bl) {
                    bl = false;
                } else {
                    string2 = string2 + ".";
                }
                string2 = string2 + string3;
            }
            ClasspathVerifier.makeClassEntry(string, string2, map);
        }
        return map;
    }

    private static Map getDirectoryClassMap(String string, File file, String string2, Map map, Pattern[] patternArray) throws Exception {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string3;
            if (fileArray[i].isDirectory()) {
                map = ClasspathVerifier.getDirectoryClassMap(string, fileArray[i], string2.length() > 0 ? string2 + "." + fileArray[i].getName() : fileArray[i].getName(), map, patternArray);
                continue;
            }
            String string4 = string3 = string2.length() > 0 ? string2 + "." + fileArray[i].getName() : string2 + fileArray[i].getName();
            if (ClasspathVerifier.matchesAnyPatterns(string3, patternArray)) continue;
            ClasspathVerifier.makeClassEntry(string, string3, map);
        }
        return map;
    }

    public static Map getClassMap(String string, String string2, Pattern[] patternArray) throws Exception {
        File[] fileArray;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            fileArray = ((File)object).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getAbsolutePath());
            }
        }
        object = new HashMap();
        fileArray = arrayList.iterator();
        while (fileArray.hasNext()) {
            String string3 = (String)fileArray.next();
            if (string3.endsWith("jar") || string3.endsWith("zip")) {
                object = ClasspathVerifier.getZipClassMap(string3, (Map)object, patternArray);
                continue;
            }
            object = ClasspathVerifier.getDirectoryClassMap(string3, new File(string3), "", (Map)object, patternArray);
        }
        return object;
    }

    public static Map getClassMapFromDirs(String string, String string2, Pattern[] patternArray) throws Exception {
        File[] fileArray;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            fileArray = ((File)object).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getAbsolutePath());
            }
        }
        object = new HashMap();
        fileArray = arrayList.iterator();
        while (fileArray.hasNext()) {
            String string3 = (String)fileArray.next();
            if (string3.endsWith("jar") || string3.endsWith("zip")) {
                object = ClasspathVerifier.getZipClassMap(string3, (Map)object, patternArray);
                continue;
            }
            object = ClasspathVerifier.getDirectoryClassMap(string3, new File(string3), "", (Map)object, patternArray);
        }
        return object;
    }

    public static Map getSystemClassMap() throws Exception {
        return ClasspathVerifier.getClassMap(System.getProperty("java.class.path"), System.getProperty("path.separator"), new Pattern[]{Pattern.compile("META-INF.*", 2)});
    }

    public static Map getTomcatClassMap() throws Exception {
        return ClasspathVerifier.getClassMap("C:\\java\\tomcat\\common\\lib;C:\\java\\tomcat\\shared\\lib;C:\\java\\tomcat\\webapps\\n2bb\\WEB-INF\\lib", System.getProperty("path.separator"), new Pattern[]{Pattern.compile("META-INF.*", 2)});
    }

    public static void printPossibleConflicts(PrintStream printStream) throws Exception {
        Map map = ClasspathVerifier.getSystemClassMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (((Collection)map.get(string)).size() <= 1) continue;
            printStream.println(string + "=" + map.get(string));
        }
    }

    public static void printPossibleConflicts2(PrintStream printStream) throws Exception {
        Map map = ClasspathVerifier.getTomcatClassMap();
        TreeSet treeSet = new TreeSet(map.keySet());
        TreeSet<String> treeSet2 = new TreeSet<String>();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (((Collection)map.get(string)).size() <= 1) continue;
            Collection collection = (Collection)map.get(string);
            String string2 = (String)collection.iterator().next();
            if (!treeSet2.contains(string2)) {
                printStream.println("\n<<" + new File(string2).getName() + ">>");
                treeSet2.add(string2);
            }
            printStream.println(string);
            printStream.println("\t\t" + collection);
        }
    }

    public static void main(String[] stringArray) {
        try {
            ClasspathVerifier.printPossibleConflicts2(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

