/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.exceptions;

import com.n2bb.commons.exceptions.N2bbException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileException
extends N2bbException {
    public FileException(Throwable throwable) {
        super(throwable);
    }

    public String getMessage() {
        return this.getCause().getMessage();
    }

    public static void checkDir(File file, boolean bl, boolean bl2, boolean bl3) throws FileException {
        FileException.check(file, bl, bl2, bl3);
        if (!file.isDirectory()) {
            throw new FileException(new IOException("File is not a DIR at path=" + file.getAbsoluteFile()));
        }
    }

    public static void checkFile(File file, boolean bl, boolean bl2, boolean bl3) throws FileException {
        FileException.check(file, bl, bl2, bl3);
        if (!file.isFile()) {
            throw new FileException(new IOException("File is not a PLAINFILE at path=" + file.getAbsoluteFile()));
        }
    }

    private static void check(File file, boolean bl, boolean bl2, boolean bl3) throws FileException {
        if (file == null) {
            throw new FileException(new IOException("File is <NULL>"));
        }
        if (bl && !file.exists()) {
            throw new FileException(new FileNotFoundException("No file at path=" + file.getAbsoluteFile()));
        }
        if (bl2 && !file.canRead()) {
            throw new FileException(new FileNotFoundException("File is not readable=" + file.getAbsoluteFile()));
        }
        if (bl3 && !file.canWrite()) {
            throw new FileException(new FileNotFoundException("File is not writable=" + file.getAbsoluteFile()));
        }
    }
}

