/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.isa;

import com.twc.isa.PackageModule.Package;
import com.twc.isa.PackageModule.PackageFactory;
import com.twc.isa.PackageModule.PackageFactoryHelper;
import com.twc.isa.PackageModule.PackageHelper;
import com.twc.isa.ServerModule.AdministrativeState;
import com.twc.isa.ServerModule.NameNotFound;
import com.twc.isa.ServerModule.ServantBaseIteratorHolder;
import com.twc.isa.ServerModule.ServantBaseListHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PackageImporter {
    private static String delimeter = "::";
    static ORB orb;
    static String[] serviceHosts;
    static String dPackageName;
    static String pAction;
    static String xFtpUser;
    static String xFtpPasswd;
    static String xFtpPrefix;
    static File adiFile;
    static PackageFactory packageFactory;
    static String adiPackageName;
    static String adiProvider;
    static String adiProduct;
    static NamingContextExt nameCtxExt;

    private PackageImporter() {
    }

    public static void main(String[] stringArray) {
        orb = null;
        int n = 0;
        try {
            String string = "corbaloc::NameServer:5000/NameService";
            String string2 = "corbaloc::SettingsServer:42000/SettingsService";
            String string3 = "30000";
            String string4 = "30000";
            String string5 = "30000";
            PackageImporter.dbg("creating JacORB orb");
            PackageImporter.dbg("SettingsService...                     " + string2);
            PackageImporter.dbg("NameService...                         " + string);
            PackageImporter.dbg("jacorb.client.pending_reply_timeout    =" + string3);
            PackageImporter.dbg("jacorb.connection.client_idle_timeout  =" + string4);
            PackageImporter.dbg("jacorb.connection.server_timeout       =" + string5);
            Properties properties = new Properties();
            properties.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            properties.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            properties.setProperty("ORBInitRef.NameService", string);
            properties.setProperty("ORBInitRef.SettingsService", string2);
            properties.setProperty("jacorb.client.pending_reply_timeout", string3);
            properties.setProperty("jacorb.connection.client_idle_timeout", string4);
            properties.setProperty("jacorb.connection.server_timeout", string5);
            orb = ORB.init((String[])stringArray, (Properties)properties);
            PackageImporter.dbg("Init'ed orb ..." + orb.toString());
            Object object = orb.resolve_initial_references("NameService");
            PackageImporter.dbg("Resolved Naming Service");
            nameCtxExt = NamingContextExtHelper.narrow((Object)object);
            PackageImporter.dbg("Narrowed Naming Service");
            n = PackageImporter.run(orb, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n = 1;
            }
        }
        System.exit(n);
    }

    public static Object getFactoryObject(String string) throws Exception {
        PackageImporter.dbg("enter");
        String[] stringArray = new String[]{"Factories", string};
        return PackageImporter.getFactoryObject(stringArray);
    }

    public static Object getFactoryObject(String[] stringArray) throws Exception {
        PackageImporter.dbg("enter");
        try {
            NamingContextExt namingContextExt = PackageImporter.getContext(stringArray, stringArray.length - 1);
            NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent(stringArray[stringArray.length - 1], "Factory")};
            Object object = namingContextExt.resolve(nameComponentArray);
            return object;
        }
        catch (Exception exception) {
            PackageImporter.err(exception.getMessage());
            exception.printStackTrace();
            throw exception;
        }
    }

    static void getAdiValues(File file) {
        InlineAdiParser inlineAdiParser = new PackageImporter().new InlineAdiParser();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(inlineAdiParser);
            xMLReader.parse(file.toURI().toASCIIString());
        }
        catch (SAXException sAXException) {
            if (!Boolean.valueOf(sAXException.getMessage()).booleanValue()) {
                PackageImporter.err("FILE IS NOT A VALID XML FILE");
                PackageImporter.err("package name=" + dPackageName);
                sAXException.printStackTrace();
                PackageImporter.err(sAXException.getMessage());
                System.exit(1);
            }
        }
        catch (Exception exception) {
            PackageImporter.err("ERROR GETTING DATA FROM ADI FILE");
            PackageImporter.err("file=" + file);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static void checkHosts() {
        for (int i = 0; i < serviceHosts.length; ++i) {
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(serviceHosts[i]);
                PackageImporter.dbg(serviceHosts[i] + " resolved to " + inetAddressArray[0]);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                PackageImporter.err("CANNOT RESOLVE REQUIRED ISA HOST, EXITING");
                PackageImporter.err("serviceHost=" + serviceHosts[i]);
                System.exit(1);
            }
        }
    }

    static void dbg(String string) {
        System.out.println("> " + string);
    }

    static void destroyPackage() {
        try {
            PackageImporter.dbg("");
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("destroy  package, package name=" + dPackageName);
            PackageImporter.dbg("------------------------------------------------------------");
            Package package_ = PackageHelper.narrow((Object)packageFactory.find("PackageFactory:" + dPackageName));
            PackageImporter.err("package located, preparing to destroy ... ");
            if (package_ != null) {
                package_.destroy();
                PackageImporter.dbg("destroyed package" + dPackageName);
            }
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("done");
        }
        catch (NameNotFound nameNotFound) {
            PackageImporter.err("PACKAGE DOES NOT EXIST ON HOST");
            PackageImporter.err("package name=" + dPackageName);
            System.exit(1);
        }
        catch (Exception exception) {
            PackageImporter.err("ERROR OCURRED DESTROYING PACKAGE");
            PackageImporter.err("package name=" + dPackageName);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static void err(String string) {
        System.out.println("> !ERROR! > " + string);
    }

    static void exportPackage() {
        try {
            PackageImporter.dbg("");
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("export package to isa host");
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.fileExists();
            PackageImporter.getAdiValues(adiFile);
            String string = xFtpPrefix + adiFile.getAbsolutePath();
            PackageImporter.dbg("package name(from adi.xml)=" + adiPackageName);
            PackageImporter.dbg("provider(from adi.xml)=" + adiProvider);
            PackageImporter.dbg("product(from adi.xml)=" + adiProduct);
            String string2 = adiProvider + delimeter + adiProduct + delimeter + adiPackageName;
            PackageImporter.dbg("isa package name=" + string2);
            PackageImporter.dbg("provisioning url=" + string);
            PackageImporter.dbg("creating package servant");
            Package package_ = PackageHelper.narrow((Object)packageFactory.createServant(string2));
            PackageImporter.dbg("servant created, id=" + package_.hashCode());
            PackageImporter.dbg("provisioning package ...");
            package_.provision(AdministrativeState.as_InService, string);
            PackageImporter.dbg("package provisioned op=" + package_.getOpState() + ", admin=" + package_.getAdminState());
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("done");
        }
        catch (Exception exception) {
            PackageImporter.err("ERROR OCURRED EXPORTING PACKAGE");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static void fileExists() {
        String string = System.getProperty("Path");
        if (string == null) {
            PackageImporter.err("USER MUST PROVIDE A FILE NAME RELATIVE TO THE CURRENT PATH ...");
            PackageImporter.err("path=" + string);
            System.exit(1);
        }
        if (!(adiFile = new File(string)).exists()) {
            PackageImporter.err("FILE DOES NOT EXIST, EXITING ...");
            PackageImporter.err("path=" + string);
            System.exit(1);
        }
        if (!adiFile.isFile()) {
            PackageImporter.err("USER SUPPLIED PATH IS A DIRECTORY, EXITING ...");
            PackageImporter.err("path=" + string);
            System.exit(1);
        }
        if (!adiFile.canRead()) {
            PackageImporter.err("CAN NOT READ FILE, CHECK PERMISIONS, EXITING ...");
            PackageImporter.err("path=" + string);
            System.exit(1);
        }
    }

    static void listPackage() {
        try {
            ServantBaseListHolder servantBaseListHolder = new ServantBaseListHolder();
            ServantBaseIteratorHolder servantBaseIteratorHolder = new ServantBaseIteratorHolder();
            PackageImporter.dbg("");
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("isa package list");
            PackageImporter.dbg("------------------------------------------------------------");
            try {
                packageFactory.list(99, servantBaseListHolder, servantBaseIteratorHolder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            PackageImporter.dbg("listing the currently available packages");
            PackageImporter.dbg("got the list, size = " + servantBaseListHolder.value.length);
            for (int i = 0; i < servantBaseListHolder.value.length; ++i) {
                String string = servantBaseListHolder.value[i].name();
                PackageImporter.dbg(i + " : " + string);
            }
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("done");
        }
        catch (Exception exception) {
            PackageImporter.err("ERROR OCURRED RETRIEVING PACKAGE LISTING FROM NAMESERVICE");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static void locateFactory() {
        try {
            String[] stringArray = new String[]{"Factories", "PackageFactory"};
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.dbg("checkign isa service hosts");
            PackageImporter.dbg("------------------------------------------------------------");
            PackageImporter.checkHosts();
            PackageImporter.dbg("looking for packagefactory in name service");
            Object object = PackageImporter.getFactoryObject(stringArray);
            PackageImporter.dbg("package factory ref: " + object);
            packageFactory = PackageFactoryHelper.narrow((Object)object);
            PackageImporter.dbg("found package factory with name : " + packageFactory.name());
            PackageImporter.dbg("------------------------------------------------------------");
        }
        catch (Exception exception) {
            PackageImporter.err("ERROR OCURRED RETRIEVING PACKAGE FACTORY FROM NAMESERVICE");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static int run(ORB oRB, String[] stringArray) {
        try {
            pAction = System.getProperty("Action", "list");
            dPackageName = System.getProperty("PackageName");
            PackageImporter.locateFactory();
            if (pAction.equals("export")) {
                PackageImporter.exportPackage();
            } else if (pAction.equals("destroy")) {
                PackageImporter.destroyPackage();
            } else if (pAction.equals("list")) {
                PackageImporter.listPackage();
            } else {
                PackageImporter.dbg("Usage: java PackageImporter [export|destroy|list]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return 0;
    }

    private static NamingContextExt getContext(String[] stringArray, int n) throws Exception {
        try {
            NameComponent[] nameComponentArray = new NameComponent[n];
            for (int i = 0; i < n; ++i) {
                nameComponentArray[i] = new NameComponent(stringArray[i], "Context");
            }
            Object object = nameCtxExt.resolve(nameComponentArray);
            return NamingContextExtHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            PackageImporter.err(exception.getMessage());
            exception.printStackTrace();
            throw exception;
        }
    }

    static {
        serviceHosts = new String[]{"NameServer", "NameService", System.getProperty("ISApackage", "Package"), System.getProperty("ISAasset", "Asset")};
        dPackageName = System.getProperty("ISApackage", "Package");
        pAction = "undefined";
        xFtpUser = System.getProperty("ftp.username", "ads");
        xFtpPasswd = System.getProperty("ftp.password", "ads123");
        packageFactory = null;
        nameCtxExt = null;
        try {
            xFtpPrefix = "ftp://" + xFtpUser + ":" + xFtpPasswd + "@" + InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            System.exit(1);
        }
    }

    public class AdiDtd
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            try {
                if (string2.equals("ADI.DTD")) {
                    return new InputSource(new FileInputStream(new File(adiFile.getParentFile(), string2)));
                }
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
    }

    public class InlineAdiParser
    extends DefaultHandler {
        public Hashtable amsValues = new Hashtable(3);

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals("AMS")) {
                adiPackageName = attributes.getValue("Asset_Name");
                adiProvider = attributes.getValue("Provider");
                adiProduct = attributes.getValue("Product");
                throw new SAXException("true");
            }
        }
    }
}

