/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.utils;

public class HexUtils {
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append(hexChar[(by & 0xF0) >>> 4]);
        stringBuffer.append(hexChar[by & 0xF]);
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexChar[(byArray[i] & 0xF0) >>> 4]);
            stringBuffer.append(hexChar[byArray[i] & 0xF]);
            stringBuffer.append(" ");
            if ((i + 1) % 8 != 0) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string) {
        int n = string.length();
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("fromHexString\u00a0requires\u00a0an\u00a0even\u00a0number\u00a0of\u00a0hex\u00a0characters");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = HexUtils.charToNibble(string.charAt(n2));
            int n5 = HexUtils.charToNibble(string.charAt(n2 + 1));
            byArray[n3] = (byte)(n4 << 4 | n5);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid\u00a0hex\u00a0character:\u00a0" + c);
    }
}

