/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.xml;

import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPrinter {
    public static final String NULLSTRING = "";

    public static void printDOMTree(Node node, PrintStream printStream) {
        try {
            short s = node.getNodeType();
            switch (s) {
                case 9: {
                    printStream.print("<?xml version=\"1.0\"  encoding= \"UTF-8\" ?>");
                    DOMPrinter.printDOMTree(((Document)node).getDocumentElement(), printStream);
                    break;
                }
                case 1: {
                    printStream.print("<");
                    printStream.print(node.getNodeName());
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Node node2 = namedNodeMap.item(i);
                        printStream.print(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                    }
                    printStream.print(">");
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        DOMPrinter.printDOMTree(nodeList.item(i), printStream);
                    }
                    break;
                }
                case 5: {
                    printStream.print("&");
                    printStream.print(node.getNodeName());
                    printStream.print(";");
                    break;
                }
                case 4: {
                    printStream.print("<![CDATA[");
                    printStream.print(node.getNodeValue());
                    printStream.print("]]>");
                    break;
                }
                case 3: {
                    printStream.print(node.getNodeValue());
                    break;
                }
                case 7: {
                    printStream.print("<?");
                    printStream.print(node.getNodeName());
                    String string = node.getNodeValue();
                    printStream.print(NULLSTRING);
                    printStream.print(string);
                    printStream.print("?>");
                }
            }
            if (s == 1) {
                printStream.println();
                printStream.print("</");
                printStream.print(node.getNodeName());
                printStream.print('>');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printDOM(Node node, PrintStream printStream) {
        try {
            short s = node.getNodeType();
            switch (s) {
                case 9: {
                    DOMPrinter.printDOM(((Document)node).getDocumentElement(), printStream);
                    break;
                }
                case 1: {
                    printStream.println(node.getNodeName());
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Node node2 = namedNodeMap.item(i);
                        printStream.println("\t\t" + node2.getNodeName() + " = " + node2.getNodeValue() + NULLSTRING);
                    }
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        DOMPrinter.printDOM(nodeList.item(i), printStream);
                    }
                    break;
                }
                case 5: {
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            if (s == 1) {
                printStream.println();
                printStream.print("</");
                printStream.print(node.getNodeName());
                printStream.print('>');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

