/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.swing.FileComboBoxBrowser;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AuthenticationPanel
extends JPanel {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final de.schlichtherle.io.File BASE_DIR;
    private static SoftReference fileChooser;
    public static final int AUTH_PASSWD = 0;
    public static final int AUTH_KEY_FILE = 1;
    private final JComboBox keyFile = new JComboBox();
    private final JButton keyFileChooser = new JButton();
    private final EnhancedPanel keyFilePanel = new EnhancedPanel();
    private JTabbedPane tabs;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuthenticationPanel() {
        this.initComponents();
        new FileComboBoxBrowser(this.keyFile).setDirectory(BASE_DIR);
        ((JTextField)this.keyFile.getEditor().getEditorComponent()).setColumns(30);
    }

    public void setPasswdPanel(JPanel passwdPanel) {
        if (passwdPanel == null) {
            throw new NullPointerException();
        }
        passwdPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String title = resources.getString("tab.passwd");
        if (title.equals(this.tabs.getTitleAt(0))) {
            this.tabs.removeTabAt(0);
        }
        this.tabs.insertTab(title, null, passwdPanel, null, 0);
        this.tabs.setSelectedIndex(0);
        this.revalidate();
    }

    Document getKeyFileDocument() {
        return ((JTextComponent)this.keyFile.getEditor().getEditorComponent()).getDocument();
    }

    public String getKeyFilePath() {
        return (String)this.keyFile.getSelectedItem();
    }

    private void setKeyFilePath(String path) {
        String oldPath = (String)this.keyFile.getSelectedItem();
        if (path == oldPath || path != null && path.equals(oldPath)) {
            return;
        }
        this.keyFile.setSelectedItem(path);
    }

    public int getAuthenticationMethod() {
        int method = this.tabs.getSelectedIndex();
        switch (method) {
            case 0: {
                if (!$assertionsDisabled && !resources.getString("tab.passwd").equals(this.tabs.getTitleAt(method))) {
                    throw new AssertionError();
                }
                break;
            }
            case 1: {
                if (!$assertionsDisabled && !resources.getString("tab.keyFile").equals(this.tabs.getTitleAt(method))) {
                    throw new AssertionError();
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported authentication method!");
            }
        }
        return method;
    }

    static JFileChooser getFileChooser() {
        JFileChooser fc;
        SoftReference ref = fileChooser;
        JFileChooser jFileChooser = fc = ref != null ? (JFileChooser)ref.get() : null;
        if (fc == null) {
            fc = new CustomFileChooser();
            fileChooser = new SoftReference<JFileChooser>(fc);
        }
        return fc;
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        JLabel keyFileLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyFilePanel.setLayout(new GridBagLayout());
        this.keyFilePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.keyFilePanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                AuthenticationPanel.this.keyFilePanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        keyFileLabel.setDisplayedMnemonic(resources.getString("keyFile").charAt(0));
        keyFileLabel.setLabelFor(this.keyFile);
        keyFileLabel.setText(resources.getString("keyFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.keyFilePanel.add((Component)keyFileLabel, gridBagConstraints);
        this.keyFile.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keyFilePanel.add((Component)this.keyFile, gridBagConstraints);
        this.keyFileChooser.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        this.keyFileChooser.setToolTipText(resources.getString("selectKeyFile.toolTip"));
        this.keyFileChooser.setName("keyFileChooser");
        this.keyFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthenticationPanel.this.keyFileChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.keyFilePanel.add((Component)this.keyFileChooser, gridBagConstraints);
        this.tabs.addTab(resources.getString("tab.keyFile"), this.keyFilePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabs, gridBagConstraints);
    }

    private void keyFileChooserActionPerformed(ActionEvent evt) {
        JFileChooser fc = AuthenticationPanel.getFileChooser();
        if (fc.showOpenDialog(this) == 0) {
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(fc.getSelectedFile(), (ArchiveDetector)ArchiveDetector.NULL);
            String baseDirPath = BASE_DIR.getCanOrAbsPath();
            String keyFilePath = file.getCanOrAbsPath();
            if (keyFilePath.startsWith(baseDirPath)) {
                if (!$assertionsDisabled && keyFilePath.charAt(baseDirPath.length()) != de.schlichtherle.io.File.separatorChar) {
                    throw new AssertionError();
                }
                keyFilePath = keyFilePath.substring(baseDirPath.length() + 1);
            }
            this.setKeyFilePath(keyFilePath);
        }
    }

    private void keyFilePanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (AuthenticationPanel.this.keyFile.requestFocusInWindow()) {
                            ((JTextComponent)AuthenticationPanel.this.keyFile.getEditor().getEditorComponent()).selectAll();
                        }
                    }
                });
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
    }

    static /* synthetic */ de.schlichtherle.io.File access$400() {
        return BASE_DIR;
    }

    static {
        $assertionsDisabled = !AuthenticationPanel.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/key/passwd/swing/AuthenticationPanel".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        BASE_DIR = new de.schlichtherle.io.File(".", (ArchiveDetector)ArchiveDetector.NULL);
    }

    private static class CustomFileChooser
    extends JFileChooser {
        private static File lastCurrentDir = AuthenticationPanel.access$400();

        public CustomFileChooser() {
            super(lastCurrentDir);
            this.setDialogTitle(resources.getString("fileChooser.title"));
            this.setFileHidingEnabled(false);
        }

        public void setCurrentDirectory(File dir) {
            super.setCurrentDirectory(dir);
            lastCurrentDir = dir;
        }

        public File getCurrentDirectory() {
            lastCurrentDir = super.getCurrentDirectory();
            return lastCurrentDir;
        }
    }
}

