/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

public class MathTool {
    public static Double add(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null) {
            return null;
        }
        return new Double(d1 + d2);
    }

    public static Double sub(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null) {
            return null;
        }
        return new Double(d1 - d2);
    }

    public static Double mul(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null) {
            return null;
        }
        return new Double(d1 * d2);
    }

    public static Double div(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null || d2 == 0.0) {
            return null;
        }
        return new Double(d1 / d2);
    }

    public static Double pow(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null) {
            return null;
        }
        return new Double(Math.pow(d1, d2));
    }

    public static Double max(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null) {
            return null;
        }
        return new Double(Math.max(d1, d2));
    }

    public static Double min(Object num1, Object num2) {
        Double d1 = MathTool.toDouble(num1);
        Double d2 = MathTool.toDouble(num2);
        if (d1 == null || d2 == null) {
            return null;
        }
        return new Double(Math.min(d1, d2));
    }

    public static Double abs(Object num) {
        Double d = MathTool.toDouble(num);
        if (d == null) {
            return null;
        }
        return new Double(Math.abs(d));
    }

    public static Double toDouble(Object num) {
        double value;
        try {
            value = num instanceof Number ? ((Number)num).doubleValue() : Double.parseDouble(String.valueOf(num));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Double(value);
    }

    public static Integer toInteger(Object num) {
        Double d = MathTool.toDouble(num);
        if (d == null) {
            return null;
        }
        return new Integer(d.intValue());
    }

    public static Double roundTo(Object decimals, Object num) {
        Integer i = MathTool.toInteger(decimals);
        Double d = MathTool.toDouble(num);
        if (i == null || d == null) {
            return null;
        }
        int places = i;
        double value = d;
        if (places == 0) {
            value = (int)(value + 0.5);
        } else {
            double shift = Math.pow(10.0, places);
            value *= shift;
            value = (int)(value + 0.5);
            value /= shift;
        }
        return new Double(value);
    }

    public static Integer roundToInt(Object num) {
        Double d = MathTool.toDouble(num);
        if (d == null) {
            return null;
        }
        return new Integer((int)Math.rint(d));
    }

    public static Double getRandom() {
        return new Double(Math.random());
    }

    public static Integer random(Object num1, Object num2) {
        Integer i1 = MathTool.toInteger(num1);
        Integer i2 = MathTool.toInteger(num2);
        if (i1 == null || i2 == null) {
            return null;
        }
        double diff = i2 - i1;
        int random = (int)Math.rint(diff * Math.random());
        return new Integer(random + i1);
    }
}

