/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm.routing;

import com.tandbergtv.workflow.adaptor.AdaptorManager;
import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.MessageRegistry;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.messageprocessor.CommandManager;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements IRoutingService {
    private static Logger logger = Logger.getLogger(Router.class);

    @Override
    public IMessage send(IMessage message) throws CommunicationException {
        logger.debug((Object)("Request " + message));
        MessageImpl ret = null;
        try {
            WorkflowMessage request = Router.toWorkflowMessage(message);
            WorkflowMessage response = CommandManager.createAndExecute((WorkflowMessage)request);
            logger.debug((Object)("Response " + response));
            ret = Router.toGenericMessage(response);
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage(), e);
        }
        return ret;
    }

    @Override
    public WorkflowMessage send(WorkflowMessage message, List<IDestination> destinations) throws CommunicationException {
        if (destinations == null || destinations.isEmpty()) {
            throw new CommunicationException("At least one destination must be specified");
        }
        logger.debug((Object)("Request " + message));
        WorkflowMessage ret = null;
        try {
            MessageImpl request = Router.toGenericMessage(message);
            AdaptorRequestImpl adaptorRequest = new AdaptorRequestImpl((IMessage)request, destinations);
            IAdaptor adaptor = AdaptorManager.getInstance().getAdaptor((IAdaptorRequest)adaptorRequest);
            IAdaptorResponse response = adaptor.transmit((IAdaptorRequest)adaptorRequest);
            ret = Router.toWorkflowMessage(response.getMessage());
            logger.debug((Object)("Response: " + ret));
        }
        catch (Exception ex) {
            throw new CommunicationException("Sending to Adaptor failed", ex);
        }
        return ret;
    }

    private static WorkflowMessage toWorkflowMessage(IMessage msg) throws Exception {
        Document document = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
        WorkflowMessage message = Unmarshaller.unmarshal(document);
        String uidValue = message.getMessageUID().getUID();
        IMessageUID uid = MessageRegistry.getInstance().getMessageUID(uidValue);
        if (uid == null) {
            throw new Exception("UID " + message.getMessageUID().getUID() + " not found in the message registry.");
        }
        message.addAttachment(msg.getAttachment());
        return message;
    }

    private static MessageImpl toGenericMessage(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringPayload payload = new StringPayload(XMLDocumentUtility.convertToString((Document)document));
        return new MessageImpl(payload, message.getAttachment());
    }
}

