/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.WPCLValidationException;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;

public class WPCLValidator {
    private static final String XSD_PATH = "com/tandbergtv/workflow/message/wpcl.xsd";

    private WPCLValidator() {
    }

    public static WPCLValidator newInstance() {
        return new WPCLValidator();
    }

    public void validate(Document document) throws WPCLValidationException {
        try {
            this.getSchema().newValidator().validate(new DOMSource(document));
        }
        catch (Exception e) {
            throw new WPCLValidationException("WPCL validation failed", e);
        }
    }

    public void validate(WorkflowMessage message) throws WPCLValidationException {
        Document document = null;
        try {
            Document doc = Marshaller.newMarshaller().marshal(message);
            String xml = XMLDocumentUtility.convertToString((Document)doc);
            document = XMLDocumentUtility.loadXml((String)xml);
        }
        catch (MarshalException e) {
            throw new WPCLValidationException("Failed to marshal the message to WPCL", e);
        }
        catch (Exception e) {
            throw new WPCLValidationException("Failed to load the message into XML", e);
        }
        this.validate(document);
    }

    public Schema getSchema() throws Exception {
        return XMLDocumentUtility.loadSchema((String)XSD_PATH);
    }
}

