/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FTPConfigurationManager {
    private static final String FTP_CONF_FILE = "com/tandbergtv/workflow/webservice/filesubsystem/ftpconfiguration.txt";
    private static FTPConfigurationManager _instance;
    private Map<String, String> hostUserNameMap = new HashMap<String, String>();
    private Map<String, String> hostPasswordMap = new HashMap<String, String>();

    private FTPConfigurationManager() throws IOException {
        this.loadConfiguration();
    }

    public static FTPConfigurationManager getInstance() throws IOException {
        if (_instance == null) {
            _instance = new FTPConfigurationManager();
        }
        return _instance;
    }

    private void loadConfiguration() throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(FTP_CONF_FILE)));
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(line, "\t");
            String host = st.nextToken();
            String userName = st.nextToken();
            String password = st.nextToken();
            this.hostUserNameMap.put(host, userName);
            this.hostPasswordMap.put(host, password);
        }
    }

    public String getUserName(String host) {
        return this.hostUserNameMap.get(host);
    }

    public String getPassword(String host) {
        return this.hostPasswordMap.get(host);
    }
}

