/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem;

import com.tandbergtv.workflow.webservice.filesubsystem.FTPClientWrapper;
import com.tandbergtv.workflow.webservice.filesubsystem.FileManagementException;
import com.tandbergtv.workflow.webservice.filesubsystem.FileManagementService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Date;
import org.apache.commons.io.FileSystemUtils;
import org.apache.log4j.Logger;

public class FileManager
implements FileManagementService {
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger(FileManager.class);
    private static FileManager instance = new FileManager();

    public static FileManager getInstance() {
        return instance;
    }

    private FileManager() {
    }

    public boolean fileExists(String filePath) {
        File f = new File(filePath);
        return f.exists() && f.isFile();
    }

    public void moveFile(String filePath, String destinationPath) throws FileManagementException {
        logger.debug((Object)("Moving file: " + filePath + " to destination path: " + destinationPath));
        File srcFile = new File(filePath);
        File destFile = new File(destinationPath);
        if (!srcFile.exists()) {
            throw new FileManagementException("File: " + srcFile + " not found.");
        }
        if (srcFile.isDirectory()) {
            throw new FileManagementException("File: " + srcFile + " is a directory which cannot be moved. Operation not allowed.");
        }
        if (destFile.isDirectory()) {
            destFile = new File(destinationPath + FILE_SEPERATOR + srcFile.getName());
        }
        if (!srcFile.renameTo(destFile)) {
            throw new FileManagementException("Cannot move File: " + srcFile + " to destination: " + destFile);
        }
        logger.info((Object)("Moved File: " + srcFile.getAbsolutePath() + " to: " + destFile.getAbsolutePath()));
    }

    public void copyFile(String filePath, String destinationPath) throws FileManagementException {
        logger.debug((Object)("Copying file: " + filePath + " to destination path: " + destinationPath));
        File srcFile = new File(filePath);
        File destFile = new File(destinationPath);
        if (!srcFile.exists()) {
            throw new FileManagementException("File: " + srcFile + " not found.");
        }
        if (srcFile.isDirectory()) {
            String msg = "File: " + srcFile + " is a directory which cannot be copied. Operation not allowed.";
            throw new FileManagementException(msg);
        }
        if (destFile.isDirectory()) {
            destFile = new File(destinationPath + FILE_SEPERATOR + srcFile.getName());
        }
        if (srcFile.equals(destFile)) {
            String msg = "Cannot copy file when the source and destination paths are the same.";
            throw new FileManagementException(msg);
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(srcFile);
            }
            catch (FileNotFoundException ex) {
                String msg = "Failed to open file: " + srcFile + " for copying.";
                throw new FileManagementException(msg, ex);
            }
            try {
                out = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException ex) {
                String msg = "Cannot open destination file: " + destFile + " for copying.";
                throw new FileManagementException(msg, ex);
            }
            FileChannel inputChannel = in.getChannel();
            FileChannel outputChannel = out.getChannel();
            long maxCount = 67076096L;
            long inputChannelSize = inputChannel.size();
            for (long position = 0L; position < inputChannelSize; position += inputChannel.transferTo(position, maxCount, outputChannel)) {
            }
        }
        catch (IOException ioe) {
            String msg = "Failed while copying the contents of file: " + srcFile + " to destination: " + destFile;
            throw new FileManagementException(msg, ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to close input stream for file: " + srcFile + " after reading the file contents."), (Throwable)ioe);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to close output stream for file: " + destFile + " after writing the copied file contents."), (Throwable)ioe);
                }
            }
        }
        logger.info((Object)("Copied File: " + srcFile.getAbsolutePath() + " to: " + destFile.getAbsolutePath()));
    }

    public void renameFile(String filePath, String newFileName) throws FileManagementException {
        logger.debug((Object)("Renaming file: " + filePath + " with new name: " + newFileName));
        File srcFile = new File(filePath);
        if (!srcFile.exists()) {
            throw new FileManagementException("File: " + srcFile + " not found.");
        }
        if (srcFile.isDirectory()) {
            String msg = "File: " + srcFile + " is a directory which cannot be renamed. Operation not allowed.";
            throw new FileManagementException(msg);
        }
        if (newFileName == null) {
            String msg = "Target File Name: " + newFileName + " is invalid (null).";
            throw new FileManagementException(msg);
        }
        String folderPath = srcFile.getParent();
        String renamedFilePath = folderPath + FILE_SEPERATOR + newFileName;
        File targetFilePath = new File(renamedFilePath);
        if (!targetFilePath.getName().equals(newFileName)) {
            String msg = "Target File Name: " + newFileName + " contains a folder path and is not a valid file name.";
            throw new FileManagementException(msg);
        }
        if (!srcFile.renameTo(new File(renamedFilePath))) {
            String msg = "Cannot rename file: " + srcFile + ". Operation failed.";
            throw new FileManagementException(msg);
        }
        logger.info((Object)("Renamed File: " + srcFile.getAbsolutePath() + " to: " + newFileName));
    }

    public void removeFile(String filePath) throws FileManagementException {
        logger.debug((Object)("Removing file: " + filePath));
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileManagementException("File: " + file + " not found.");
        }
        if (file.isDirectory()) {
            throw new FileManagementException("File: " + file + " is a directory and cannot be removed. Operation not allowed.");
        }
        if (!file.delete()) {
            throw new FileManagementException("Cannot delete File: " + file + ". Operation failed.");
        }
        logger.info((Object)("Removed File: " + file.getAbsolutePath()));
    }

    public long getFileSize(String filePath) throws FileManagementException {
        logger.debug((Object)("Getting File Size for file: " + filePath));
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileManagementException("File: " + file + " not found.");
        }
        if (file.isDirectory()) {
            throw new FileManagementException("No file name specified in the path: " + file);
        }
        logger.info((Object)("Got File Size for File: " + file.getAbsolutePath()));
        return file.length();
    }

    public long getFolderSize(String folderPath) throws FileManagementException {
        logger.debug((Object)("Calculating size of Folder: " + folderPath));
        File file = new File(folderPath);
        if (!file.exists()) {
            throw new FileManagementException("Folder: " + file + " not found.");
        }
        if (!file.isDirectory()) {
            throw new FileManagementException("Folder: " + file + " is not a folder.");
        }
        UsageStatistics stats = new UsageStatistics();
        long folderSize = this.getFolderSize(file, stats);
        stats.endDate = new Date();
        logger.info((Object)("Got Folder Size for Folder: " + file.getAbsolutePath() + " with Usage Statistics: " + stats.toString()));
        return folderSize;
    }

    private long getFolderSize(File file, UsageStatistics stats) {
        if (file == null) {
            return 0L;
        }
        long fileSize = 0L;
        if (file.isDirectory()) {
            File[] files;
            ++stats.directoryCount;
            for (File childFile : files = file.listFiles()) {
                fileSize += this.getFolderSize(childFile, stats);
            }
        } else {
            ++stats.fileCount;
            fileSize = file.length();
        }
        return fileSize;
    }

    public File[] getFileList(String folderPath, final boolean filesOnly) throws FileManagementException {
        File file = new File(folderPath);
        if (!file.exists() || !file.isDirectory()) {
            String msg = "The file listing is requested for folder: " + folderPath + " which does not exist.";
            logger.warn((Object)msg);
        }
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return filesOnly != pathname.isDirectory();
            }
        };
        return file.listFiles(filter);
    }

    public long getDriveFreeSpace(String drive) throws FileManagementException {
        long free = 0L;
        try {
            free = FileSystemUtils.freeSpaceKb((String)drive) * 1024L;
        }
        catch (IOException e) {
            throw new FileManagementException("Failed to get free space on drive " + drive, e);
        }
        return free;
    }

    public long getDriveTotalSpace(String drive) throws FileManagementException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ftpDownload(String sourcePath, String destinationPath, String host, String username, String password) {
        block8: {
            logger.debug((Object)("sourcePath= " + sourcePath + ", destinationPath= " + destinationPath + ", host=" + host + ", username= " + username + ", password= " + password));
            FTPClientWrapper ftp = new FTPClientWrapper();
            try {
                if (ftp.connLogin(host, username, password)) {
                    try {
                        ftp.downloadFile(sourcePath, destinationPath);
                        logger.debug((Object)("downloading " + sourcePath + " completed"));
                        break block8;
                    }
                    catch (Exception ftpe) {
                        logger.error((Object)"Exception while ftp downloading: ", (Throwable)ftpe);
                        break block8;
                    }
                    finally {
                        ftp.logout();
                        ftp.disconnect();
                    }
                }
                logger.error((Object)("Unable to connect to " + host));
            }
            catch (Exception e) {
                logger.error((Object)"Exception while connecting to ftp: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ftpUpload(String sourcePath, String destinationPath, String host, String username, String password) {
        block8: {
            logger.debug((Object)("sourcePath= " + sourcePath + ", destinationPath= " + destinationPath + ", host=" + host + ", username= " + username + ", password= " + password));
            FTPClientWrapper ftp = new FTPClientWrapper();
            try {
                if (ftp.connLogin(host, username, password)) {
                    try {
                        ftp.uploadFile(sourcePath, destinationPath);
                        logger.debug((Object)("uploading " + sourcePath + " completed"));
                        break block8;
                    }
                    catch (Exception ftpe) {
                        logger.error((Object)"Exception while ftp uploading: ", (Throwable)ftpe);
                        break block8;
                    }
                    finally {
                        ftp.logout();
                        ftp.disconnect();
                    }
                }
                logger.error((Object)("Unable to connect to " + host));
            }
            catch (Exception e) {
                logger.error((Object)"Exception while connecting to ftp: ", (Throwable)e);
            }
        }
    }

    private class UsageStatistics {
        int fileCount = 0;
        int directoryCount = 0;
        Date startDate = new Date();
        Date endDate = null;

        private UsageStatistics() {
        }

        public String toString() {
            String display = LINE_SEPERATOR + "\tQuery Start: " + this.startDate.toString();
            display = display + LINE_SEPERATOR + "\tQuery End: " + this.endDate.toString();
            display = display + LINE_SEPERATOR + "\tDirectory Count: " + this.directoryCount;
            display = display + LINE_SEPERATOR + "\tFile Count: " + this.fileCount;
            return display;
        }
    }
}

