/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.webservice.filesubsystem.OperationException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RequestHandler {
    private static final String WORKFLOW_MESSAGE_ELEMENT = "WFSMessage";
    private static RequestHandler instance = null;
    private DocumentBuilder docBuilder = null;

    public static synchronized RequestHandler getInstance() throws ParserConfigurationException {
        if (instance == null) {
            instance = new RequestHandler();
        }
        return instance;
    }

    private RequestHandler() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.docBuilder = factory.newDocumentBuilder();
    }

    public WorkflowMessage parseRequest(SOAPEnvelope request) throws OperationException {
        try {
            SOAPMessage soapMessage = MessageContext.getCurrentContext().getMessage();
            SOAPBody body = soapMessage.getSOAPBody();
            Element workflowMessageElement = null;
            Iterator iterator = body.getChildElements();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!element.getNodeName().equals(WORKFLOW_MESSAGE_ELEMENT)) continue;
                workflowMessageElement = element;
                break;
            }
            if (workflowMessageElement == null) {
                String error = "Failed to find the Workflow Message in the SOAP request, unable to process request.";
                throw new OperationException(error);
            }
            Document workflowMessageDocument = this.docBuilder.newDocument();
            Node messageNode = workflowMessageDocument.importNode(workflowMessageElement, true);
            workflowMessageDocument.appendChild(messageNode);
            WorkflowMessage message = Unmarshaller.unmarshal(workflowMessageDocument);
            return message;
        }
        catch (SOAPException se) {
            String msg = "Failed to read the SOAP Envelope for the File Subsystem request.";
            throw new OperationException(msg, se);
        }
        catch (DOMException de) {
            String msg = "Failed to import the Workflow Message element into a new XML Document.";
            throw new OperationException(msg, de);
        }
        catch (MarshalException me) {
            String msg = "Failed to unmarshal the Workflow Message element in the File Subsystem request.";
            throw new OperationException(msg, me);
        }
        catch (Exception ex) {
            String msg = "Unexpected error when parsing the SOAP Envelope containing the File Subsystem request.";
            throw new OperationException(msg, ex);
        }
    }
}

