/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem.messagehandler;

import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.webservice.filesubsystem.FileSubsystemWebservice;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(AbstractMessageHandler.class);
    public static final String ASYNC_MESSAGE_UID = "070107";

    public WorkflowMessage handleMessage(WorkflowMessage message) {
        WorkflowMessage response = this.createEmptyResponseMessage(message);
        try {
            this.performOperation(message, response);
            boolean isAsync = FileSubsystemWebservice.isAsyncMessage(message);
            response.setType(isAsync ? WorkflowMessage.MessageType.notification : WorkflowMessage.MessageType.ack);
        }
        catch (Exception ex) {
            response.setType(WorkflowMessage.MessageType.nack);
            this.handleOperationException(ex, response);
        }
        return response;
    }

    protected abstract void performOperation(WorkflowMessage var1, WorkflowMessage var2) throws Exception;

    protected void handleOperationException(Throwable ex, WorkflowMessage response) {
        this.writeErrorProperties(response, ex);
        logger.error((Object)("Failed to perform File Subsystem Operation: " + ex.getMessage()), ex);
    }

    protected WorkflowMessage createEmptyResponseMessage(WorkflowMessage message) {
        IMessageUID messageUID = message.getMessageUID();
        if (FileSubsystemWebservice.isAsyncMessage(message)) {
            messageUID = new MessageUIDImpl(ASYNC_MESSAGE_UID);
        }
        return new WorkflowMessage(messageUID, message.getKey());
    }

    protected void writeErrorProperties(WorkflowMessage response, Throwable ex) {
        WorkflowPayload payload = response.getPayload();
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        payload.putValue("error-message", ex.getMessage());
        payload.putValue("error-stack", writer.toString());
    }
}

