/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem.messagehandler;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.webservice.filesubsystem.FTPConfigurationManager;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.FileManagementMessageHandler;
import org.apache.log4j.Logger;

public class FTPMessageHandler
extends FileManagementMessageHandler {
    private static final Logger logger = Logger.getLogger(FTPMessageHandler.class);
    private static final String FTP_URL_PREFIX = "ftp:";

    protected void performOperation(WorkflowMessage message, WorkflowMessage response) throws Exception {
        WorkflowPayload payload = message.getPayload();
        String sourcePath = payload.getValue("SourcePath");
        String destinationPath = payload.getValue("DestinationPath");
        if (sourcePath.toLowerCase().startsWith(FTP_URL_PREFIX)) {
            String host = this.getHostFromFtpUrl(sourcePath);
            String userName = FTPConfigurationManager.getInstance().getUserName(host);
            String password = FTPConfigurationManager.getInstance().getPassword(host);
            String sourceFilePath = this.getFilePathFromFtpUrl(sourcePath);
            logger.debug((Object)(sourceFilePath + " | " + destinationPath + " | " + host + " | " + userName + " | " + password));
            this.getService().ftpDownload(sourceFilePath, destinationPath, host, userName, password);
            logger.debug((Object)"Finished downloading");
        } else {
            String host = this.getHostFromFtpUrl(destinationPath);
            String userName = FTPConfigurationManager.getInstance().getUserName(host);
            String password = FTPConfigurationManager.getInstance().getPassword(host);
            String destinationFilePath = this.getFilePathFromFtpUrl(destinationPath);
            logger.debug((Object)(sourcePath + " | " + destinationFilePath + " | " + host + " | " + userName + " | " + password));
            this.getService().ftpUpload(sourcePath, destinationFilePath, host, userName, password);
            logger.debug((Object)"Finished uploading");
        }
    }

    private String getHostFromFtpUrl(String ftpUrl) {
        return ftpUrl.substring(6, ftpUrl.indexOf(47, 6));
    }

    private String getFilePathFromFtpUrl(String ftpUrl) {
        return ftpUrl.substring(ftpUrl.indexOf(47, 6));
    }
}

