/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem.messagehandler;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLObjectSerializer;
import com.tandbergtv.workflow.webservice.filesubsystem.entity.SANFile;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.FileManagementMessageHandler;
import java.io.File;
import java.util.ArrayList;

public class FileListingMessageHandler
extends FileManagementMessageHandler {
    protected void performOperation(WorkflowMessage message, WorkflowMessage response) throws Exception {
        WorkflowPayload payload = message.getPayload();
        String folderPath = payload.getValue("Path");
        File[] files = this.getService().getFileList(folderPath, true);
        ArrayList<SANFile> fileList = new ArrayList<SANFile>();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                fileList.add(this.createSANFile(file));
            }
        }
        String xmlResult = XMLObjectSerializer.serializeObject(fileList);
        WorkflowPayload outPayload = response.getPayload();
        outPayload.putValue("Result", xmlResult);
    }

    private SANFile createSANFile(File file) {
        SANFile sanFile = new SANFile();
        sanFile.setLength(file.length());
        sanFile.setAbsolutePath(file.getAbsolutePath());
        sanFile.setName(file.getName());
        sanFile.setLastModified(file.lastModified());
        return sanFile;
    }
}

