/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.filesubsystem.messagehandler;

import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageConfiguration;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandler;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandlerConfigReader;
import com.tandbergtv.workflow.webservice.filesubsystem.messagehandler.MessageHandlerConfigurationException;
import java.util.Map;

public class MessageHandlerFactory {
    private static MessageHandlerFactory instance = null;
    private Map<String, MessageConfiguration> configurationMap = MessageHandlerConfigReader.readConfiguration();

    public static synchronized MessageHandlerFactory getInstance() throws MessageHandlerConfigurationException {
        if (instance == null) {
            instance = new MessageHandlerFactory();
        }
        return instance;
    }

    private MessageHandlerFactory() throws MessageHandlerConfigurationException {
    }

    public MessageHandler getMessageHandler(String messageUID) throws MessageHandlerConfigurationException {
        MessageConfiguration config;
        String className;
        if (messageUID != null) {
            messageUID = messageUID.trim();
        }
        String string = className = (config = this.configurationMap.get(messageUID)) != null ? config.getHandlerClassName() : null;
        if (className == null) {
            String msg = "The Message UID: " + messageUID + " does not have a Message Handler configured for it.";
            throw new MessageHandlerConfigurationException(msg);
        }
        return this.loadMessageHandler(className);
    }

    public boolean isMessageSynchronous(String messageUID) throws MessageHandlerConfigurationException {
        MessageConfiguration config;
        if (messageUID != null) {
            messageUID = messageUID.trim();
        }
        if ((config = this.configurationMap.get(messageUID)) == null) {
            String msg = "The Message UID: " + messageUID + " is not configured and cannot be handled.";
            throw new MessageHandlerConfigurationException(msg);
        }
        return config.isSynchronous();
    }

    private MessageHandler loadMessageHandler(String className) throws MessageHandlerConfigurationException {
        Object handlerClass = null;
        try {
            Class<?> refClass = Class.forName(className);
            handlerClass = refClass.newInstance();
        }
        catch (Exception ex) {
            String msg = "Failed to create instance of Message Handler class: " + className;
            throw new MessageHandlerConfigurationException(msg, ex);
        }
        if (!(handlerClass instanceof MessageHandler)) {
            String msg = "The configured Message Handler class: " + className + " does not implement: " + MessageHandler.class.getName();
            throw new MessageHandlerConfigurationException(msg);
        }
        return handlerClass;
    }
}

