/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AbstractNonTarFilesMonitoringProcess
implements IProcess {
    private static final Logger logger = Logger.getLogger(AbstractNonTarFilesMonitoringProcess.class);
    protected static final String SOURCE_URL = "SourceURL";
    protected static final String UNKNOWN_VALUE = "Unknown";
    protected static final String FAILED_FOLDER = "FailedFolder";
    protected static final String THREAD_SLEEP_TIME = "ThreadSleepTime";
    protected static final String MAX_COPY_WAIT_TIME = "MaxCopyWaitTime";

    protected void handleFailure(String errorMessage, String filePath) {
        this.sendAssetArrivalFailure(errorMessage);
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            ProcessUtil.newInstance().moveFile(filePath, failedFolder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while moving the non-tar file to the failed folder", (Throwable)e);
        }
    }

    protected abstract void sendAssetArrivalFailure(String var1);

    public void fileCreated(FileInfo fileInfo) {
        logger.info((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        try {
            if (this.isTarFile(fileInfo.getName())) {
                logger.debug((Object)(fileInfo.getAbsolutePath() + " is a tar file"));
            } else {
                int threadSleepTime = Integer.parseInt(this.getProperty(THREAD_SLEEP_TIME));
                int maxCopyTime = Integer.parseInt(this.getProperty(MAX_COPY_WAIT_TIME));
                String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
                if (!ProcessUtil.newInstance().waitTillFileCopyComplete(fileInfo.getAbsolutePath(), threadSleepTime, maxCopyTime)) {
                    String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + fileInfo.getAbsolutePath();
                    logger.error((Object)errorMessage);
                    this.sendAssetArrivalFailure(errorMessage);
                    return;
                }
                logger.info((Object)(failedFolder + fileInfo.getName() + " is not a tar file."));
                this.handleFailure(failedFolder + fileInfo.getName() + " is not a tar file.", fileInfo.getAbsolutePath());
            }
            return;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
            return;
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    private boolean isTarFile(String fileName) {
        return Pattern.matches(".*tar", fileName.toLowerCase());
    }

    protected String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }
}

