/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.webservice.watchfolder.AdultVODProcess;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.TarProcess;
import org.apache.log4j.Logger;

public class AdultTarProcess
extends TarProcess {
    private static final Logger logger = Logger.getLogger(AdultTarProcess.class);
    private static final String ADULT_AAF_MESSAGE_UID = "AdultAAFMessageUID";

    public void fileCreated(FileInfo fileInfo) {
        logger.info((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        try {
            int threadSleepTime = Integer.parseInt(this.getProperty("ThreadSleepTime"));
            int maxCopyTime = Integer.parseInt(this.getProperty("MaxCopyWaitTime"));
            String failedFolder = this.getProperty("FailedFolder") + "\\";
            if (!ProcessUtil.newInstance().waitTillFileCopyComplete(fileInfo.getAbsolutePath(), threadSleepTime, maxCopyTime)) {
                String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + fileInfo.getAbsolutePath();
                logger.error((Object)errorMessage);
                this.sendAssetArrivalFailure(errorMessage, ADULT_AAF_MESSAGE_UID);
                return;
            }
            String adiFileName = null;
            try {
                adiFileName = this.getADIFileName(fileInfo.getAbsolutePath());
                this.loadADI(fileInfo.getAbsolutePath() + "\\" + adiFileName);
                if (!this.isVODAsset()) {
                    String errorMessage = "The asset type cannot be recognized: " + failedFolder + adiFileName;
                    logger.error((Object)errorMessage);
                    this.moveFileToFalledFolder(fileInfo, failedFolder);
                    this.sendAssetArrivalFailure(errorMessage, ADULT_AAF_MESSAGE_UID);
                    return;
                }
                logger.info((Object)"The asset type is VOD");
                AdultVODProcess vodProcess = new AdultVODProcess(this.adiParser);
                vodProcess.fileCreated(fileInfo);
            }
            catch (Exception e) {
                String errorMessage = "Unable to load metadata file from: " + failedFolder + fileInfo.getName();
                logger.error((Object)errorMessage, (Throwable)e);
                this.moveFileToFalledFolder(fileInfo, failedFolder);
                this.sendAssetArrivalFailure(errorMessage + " | " + e.getMessage(), ADULT_AAF_MESSAGE_UID);
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
        }
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }
}

