/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcess
implements IProcess {
    private static final Logger logger = Logger.getLogger(DefaultProcess.class);
    private static final String SOURCE_URL = "SourceURL";
    private static final String DPS_MESSAGE_UID = "DefaultProcess.MessageUID";
    private static final String THREAD_SLEEP_TIME = "ThreadSleepTime";
    private static final String MAX_COPY_WAIT_TIME = "MaxCopyWaitTime";
    private static final String FAILED_FOLDER = "FailedFolder";
    private Map<String, String> parameterList;

    public DefaultProcess() {
    }

    public DefaultProcess(Map<String, String> parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public void fileCreated(FileInfo fileInfo) {
        logger.debug((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        String failedFolder = "";
        try {
            failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            int threadSleepTime = Integer.parseInt(this.getProperty(THREAD_SLEEP_TIME));
            int maxCopyTime = Integer.parseInt(this.getProperty(MAX_COPY_WAIT_TIME));
            if (!ProcessUtil.newInstance().waitTillFileCopyComplete(fileInfo.getAbsolutePath(), threadSleepTime, maxCopyTime)) {
                String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + fileInfo.getAbsolutePath();
                logger.error((Object)errorMessage);
                this.handleFailure(errorMessage, fileInfo);
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "Exception while creating file: " + failedFolder + fileInfo.getName();
            logger.error((Object)errorMessage, (Throwable)e);
            this.handleFailure(errorMessage + " | " + e.getMessage(), fileInfo);
            return;
        }
        WorkflowMessage message = null;
        try {
            message = this.prepareMessage(fileInfo);
        }
        catch (Exception e) {
            String errorMessage = "Exception while preparing Message: " + failedFolder + fileInfo.getName();
            logger.error((Object)errorMessage, (Throwable)e);
            this.handleFailure(errorMessage + " | " + e.getMessage(), fileInfo);
            return;
        }
        try {
            logger.debug((Object)("Message Created is " + message.getPayload()));
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to send  message to Watch Point", (Throwable)e);
            return;
        }
        try {
            ProcessUtil.newInstance().deleteFile(fileInfo.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error((Object)("Exception in deleting the  file: " + fileInfo.getAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    @Override
    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    private WorkflowMessage prepareMessage(FileInfo fileInfo) throws Exception {
        logger.debug((Object)"Preparing  message");
        String DATE_FORMAT = this.parameterList.get("dateFormat");
        Map<String, String> cmdParamList = this.getCommandParameters();
        WPCLCommand wpclCmd = new WPCLCommand(this.parameterList.get("command"));
        wpclCmd.setParameters(cmdParamList);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(DPS_MESSAGE_UID)), WorkflowMessage.MessageType.control);
        message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
        message.putValue("filePath", fileInfo.getAbsolutePath());
        message.putValue("fileSize", new Long(fileInfo.getSize()).toString());
        message.putValue("fileName", fileInfo.getName());
        message.putValue("lastModified", sdf.format(new Date(fileInfo.getLastModified())).toString());
        message.putValue("fileType", fileInfo.getExtension());
        message.setCommand(wpclCmd);
        return message;
    }

    private Map<String, String> getCommandParameters() {
        HashMap<String, String> cmdParamList = new HashMap<String, String>();
        for (String key : this.parameterList.keySet()) {
            if (!key.equalsIgnoreCase("selector") && !key.equalsIgnoreCase("priority") && !key.equalsIgnoreCase("prioritySelector")) continue;
            cmdParamList.put(key, this.parameterList.get(key));
        }
        return cmdParamList;
    }

    private void handleFailure(String errorMessage, FileInfo fileInfo) {
        logger.debug((Object)"Sending Failure message to Workflow");
        try {
            String DATE_FORMAT = this.parameterList.get("dateFormat");
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(DPS_MESSAGE_UID)), WorkflowMessage.MessageType.nack);
            message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
            message.putValue("filePath", fileInfo.getAbsolutePath());
            message.putValue("fileSize", new Long(fileInfo.getSize()).toString());
            message.putValue("fileName", fileInfo.getName());
            message.putValue("lastModified", sdf.format(new Date(fileInfo.getLastModified())).toString());
            message.putValue("fileType", fileInfo.getExtension());
            message.setCommand(new WPCLCommand(this.parameterList.get("command")));
            message.putValue("error-message", errorMessage);
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending  Failure messsage to Workflow", (Throwable)e);
        }
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            ProcessUtil.newInstance().moveFile(fileInfo.getAbsolutePath(), failedFolder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while moving the  file to the failed folder", (Throwable)e);
        }
    }

    private String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }
}

