/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class Dispatcher {
    private static final Logger logger = Logger.getLogger(Dispatcher.class);
    private static final String PROPERTIES_CONNECTION_STRING = "ConnectionString";

    private static String getPropertyValue(String key) {
        String result = null;
        try {
            result = WatchfolderProperties.getInstance().getProperty(key);
        }
        catch (Throwable ex) {
            logger.error((Object)"Error in getPropertyValue:", ex);
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(WorkflowMessage wfsMessage) throws Exception {
        Document doc = Marshaller.newMarshaller().marshal(wfsMessage);
        String connString = Dispatcher.getPropertyValue(PROPERTIES_CONNECTION_STRING);
        logger.info((Object)("Making SOAP call to " + connString));
        SOAPMessage message = MessageFactory.newInstance().createMessage();
        MimeHeaders headers = message.getMimeHeaders();
        headers.addHeader("SOAPAction", "");
        SOAPBody requestBody = message.getSOAPBody();
        requestBody.addDocument(doc);
        SOAPConnection connection = null;
        SOAPMessage reply = null;
        try {
            connection = SOAPConnectionFactory.newInstance().createConnection();
            reply = connection.call(message, (Object)connString);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        SOAPBody body = reply.getSOAPBody();
        if (body.getFault() != null) {
            SOAPFault fault = body.getFault();
            throw new SOAPException("Got a soap fault in the response: " + fault.getFaultString());
        }
        Document responseDocument = body.extractContentAsDocument();
        WorkflowMessage responseMessage = Unmarshaller.unmarshal(responseDocument);
        if (responseMessage.getType() == WorkflowMessage.MessageType.nack) {
            throw new RuntimeException("Nack response received | Response Message: " + responseMessage);
        }
    }
}

