/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.adi.ADI11Parser;
import com.tandbergtv.workflow.util.adi.Asset;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.TarUtil;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HomePageProcess
implements IProcess {
    private static final Logger logger = Logger.getLogger(HomePageProcess.class);
    private static final String SOURCE_URL = "SourceURL";
    private static final String ADI_FILE_NAME = "ADIFileName";
    private static final String UNTAR_DIRPATH_PREFIX = "HomePageProcess.UntarDirPathPrefix";
    private static final String AAS_MESSAGE_UID = "HomePageProcess.AASMessageUID";
    private static final String AAF_MESSAGE_UID = "AAFMessageUID";
    private static final String CONTENT_TYPE_COMPLETE = "complete";
    private static final String CONTENT_TYPE_BACKGROUND = "background";
    private static final String ASSET_XPATH = "//Asset/Asset";
    private static final String METADATA_NODE = "metadata";
    private static final String CONTENT_NODE = "content";
    private static final String AMS_NODE = "ams";
    private static final String AMS_ASSET_CLASS_ATTRIBUTE = "Asset_Class";
    private static final String CONTENT_VALUE_ATTRIBUTE = "Value";
    private static final String UNKNOWN_VALUE = "Unknown";
    private static final String FAILED_FOLDER = "FailedFolder";
    private ADI11Parser adiParser;

    public HomePageProcess(ADI11Parser adiParser) {
        this.adiParser = adiParser;
    }

    public void fileCreated(FileInfo fileInfo) {
        logger.debug((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            String adiFileName = this.getProperty(ADI_FILE_NAME);
            String explodedDirPath = this.getProperty(UNTAR_DIRPATH_PREFIX) + fileInfo.getName() + "_" + System.currentTimeMillis() + "\\";
            try {
                logger.debug((Object)"trying to untar...");
                TarUtil.getInstance().unpack(fileInfo.getAbsolutePath(), explodedDirPath);
            }
            catch (Exception e) {
                String errorMessage = "Exception while untarring file: " + failedFolder + fileInfo.getName();
                logger.error((Object)errorMessage, (Throwable)e);
                this.handleFailure(errorMessage + " | " + e.getMessage(), fileInfo.getAbsolutePath());
                return;
            }
            WorkflowMessage message = null;
            try {
                message = this.prepareAASMessage(explodedDirPath, adiFileName);
            }
            catch (Exception e) {
                String errorMessage = "Exception while preparing AASMessage: " + failedFolder + fileInfo.getName();
                logger.error((Object)errorMessage, (Throwable)e);
                this.handleFailure(errorMessage + " | " + e.getMessage(), fileInfo.getAbsolutePath());
                return;
            }
            try {
                Dispatcher.send(message);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to send Asset Arrival Success message to Workflow", (Throwable)e);
                return;
            }
            try {
                ProcessUtil.newInstance().deleteFile(fileInfo.getAbsolutePath());
            }
            catch (Exception e) {
                logger.error((Object)("Exception in deleting the tar file: " + fileInfo.getAbsolutePath()), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    private Asset getAsset(String contentType) {
        for (Asset asset : this.adiParser.extractAssets()) {
            if (!asset.getContentType().equals(contentType)) continue;
            return asset;
        }
        return null;
    }

    private String getAssetID(String contentType) {
        Asset asset = this.getAsset(contentType);
        if (asset != null) {
            return asset.getAssetId();
        }
        return null;
    }

    private String getContentFileName(String contentType) throws XPathExpressionException {
        NodeList nodes = this.adiParser.getNodes(ASSET_XPATH);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Node metadataNode = this.getChildNode(node, METADATA_NODE);
            Node amsNode = this.getChildNode(metadataNode, AMS_NODE);
            String assetClassValue = this.getAttributeValue(amsNode, AMS_ASSET_CLASS_ATTRIBUTE);
            if (assetClassValue == null || !assetClassValue.equalsIgnoreCase(contentType)) continue;
            Node contentNode = this.getChildNode(node, CONTENT_NODE);
            return this.getAttributeValue(contentNode, CONTENT_VALUE_ATTRIBUTE);
        }
        return null;
    }

    private Node getChildNode(Node node, String childNodeName) {
        NodeList childNodes = node.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            if (childNode == null || childNode.getNodeName() == null || !childNode.getNodeName().equalsIgnoreCase(childNodeName)) continue;
            return childNode;
        }
        return null;
    }

    private String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            if (attributeNode == null || attributeNode.getNodeName() == null || !attributeNode.getNodeName().equalsIgnoreCase(attributeName)) continue;
            return attributeNode.getNodeValue();
        }
        return null;
    }

    private WorkflowMessage prepareAASMessage(String explodedDirPath, String adiFileName) throws Exception {
        logger.debug((Object)"Preparing AAS message");
        String packageAssetID = this.adiParser.getPackageAssetID();
        String providerID = this.adiParser.getProviderID();
        String titleBrief = this.adiParser.getPackageDescription();
        String metadataFilePath = explodedDirPath + adiFileName;
        String completeAssetID = this.getAssetID(CONTENT_TYPE_COMPLETE);
        String completeInputPath = this.getContentFileName(CONTENT_TYPE_COMPLETE);
        completeInputPath = completeInputPath == null ? null : explodedDirPath + completeInputPath;
        String backgroundAssetID = this.getAssetID(CONTENT_TYPE_BACKGROUND);
        String backgroundInputPath = this.getContentFileName(CONTENT_TYPE_BACKGROUND);
        backgroundInputPath = backgroundInputPath == null ? null : explodedDirPath + backgroundInputPath;
        WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(AAS_MESSAGE_UID)), WorkflowMessage.MessageType.control);
        message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
        message.putValue("providerId", providerID);
        message.putValue("packageAssetId", packageAssetID);
        message.putValue("metadataFilePath", metadataFilePath);
        message.putValue("titleBrief", titleBrief);
        message.putValue("backgroundAssetId", backgroundAssetID);
        message.putValue("backgroundInputPath", backgroundInputPath);
        message.putValue("completeAssetId", completeAssetID);
        message.putValue("completeInputPath", completeInputPath);
        message.setCommand(new WPCLCommand("Create"));
        return message;
    }

    private void handleFailure(String errorMessage, String filePath) {
        logger.debug((Object)"Sending Asset Arrival Failure message to Workflow");
        String providerID = null;
        String packageAssetID = null;
        try {
            providerID = this.adiParser.getProviderID();
            packageAssetID = this.adiParser.getPackageAssetID();
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while reading adi file");
        }
        providerID = providerID == null ? UNKNOWN_VALUE : providerID;
        packageAssetID = packageAssetID == null ? UNKNOWN_VALUE : packageAssetID;
        try {
            WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(AAF_MESSAGE_UID)), WorkflowMessage.MessageType.control);
            message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
            message.putValue("providerId", providerID);
            message.putValue("packageAssetId", packageAssetID);
            message.putValue("error-message", errorMessage);
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending Asset Arrival Failure messsage to Workflow", (Throwable)e);
        }
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            ProcessUtil.newInstance().moveFile(filePath, failedFolder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while moving the tar file to the failed folder", (Throwable)e);
        }
    }

    private String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }
}

