/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.webservice.watchfolder.DirectoryMonitor;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.Processor;
import com.tandbergtv.workflow.webservice.watchfolder.WPFileFilter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDirectoryMonitor
extends DirectoryMonitor {
    private static final Logger logger = Logger.getLogger(LocalDirectoryMonitor.class);
    String path;

    public LocalDirectoryMonitor(String path, Set<WPFileFilter> fileFilters, Processor processor) {
        super(fileFilters, processor);
        this.path = path;
        logger.debug((Object)("Local Directory Monitor constructor called | path: " + path));
    }

    @Override
    protected Map<String, FileInfo> getFiles() {
        logger.debug((Object)"Local Directory Monitor's getFiles()");
        HashMap<String, FileInfo> files = new HashMap<String, FileInfo>();
        File directory = new File(this.path);
        if (!directory.exists()) {
            logger.warn((Object)("Directory with path: " + this.path + " does not exist"));
            return files;
        }
        for (File file : directory.listFiles()) {
            files.put(file.getName(), this.getFileInfo(file));
        }
        return files;
    }

    private FileInfo getFileInfo(File file) {
        return new FileInfo(file.getName(), file.length(), file.lastModified(), file.getAbsolutePath());
    }
}

