/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.adi.ADI11Parser;
import com.tandbergtv.workflow.util.adi.Asset;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import com.tandbergtv.workflow.webservice.watchfolder.MobileProcessProperties;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobileProcess
implements IProcess {
    private static final Logger logger = Logger.getLogger(MobileProcess.class);
    private static final String SOURCE_URL = "SourceURL";
    private static final String MOBILE_ORIGINAL_FOLDER = "MobileProcess.MobileOriginalFolder";
    private static final String AAS_MESSAGE_UID = "MobileProcess.AASMessageUID";
    private static final String AAF_MESSAGE_UID = "MobileProcess.AAFMessageUID";
    private static final String THREAD_SLEEP_TIME = "MobileProcess.ThreadSleepTime";
    private static final String MAX_COPY_WAIT_TIME = "MobileProcess.MaxCopyWaitTime";
    private static final String CONTENT_TYPE_CLIP = "movie";
    private static final String ASSET_XPATH = "//Asset/Asset";
    private static final String METADATA_NODE = "metadata";
    private static final String CONTENT_NODE = "content";
    private static final String AMS_NODE = "ams";
    private static final String AMS_ASSET_CLASS_ATTRIBUTE = "Asset_Class";
    private static final String CONTENT_VALUE_ATTRIBUTE = "Value";
    private static final String UNKNOWN_VALUE = "Unknown";
    private static final String XML_EXTENSION = ".xml";
    private static final String FAILED_FOLDER = "FailedFolder";
    private static final String MAX_DROP_WAIT_TIME_FOR_XML = "MobileProcess.MaxDropWaitTimeForXML";
    ADI11Parser adiParser;

    public void fileCreated(FileInfo fileInfo) {
        logger.info((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        try {
            int maxDropWaitTime;
            int threadSleepTime = Integer.parseInt(this.getProcessProperty(THREAD_SLEEP_TIME));
            int maxCopyWaitTime = Integer.parseInt(this.getProcessProperty(MAX_COPY_WAIT_TIME));
            String failedFolder = this.getProcessProperty(FAILED_FOLDER) + "\\";
            if (!ProcessUtil.newInstance().waitTillFileCopyComplete(fileInfo.getAbsolutePath(), threadSleepTime, maxCopyWaitTime)) {
                String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + fileInfo.getAbsolutePath();
                logger.error((Object)errorMessage);
                this.sendAssetArrivalFailure(errorMessage);
                return;
            }
            String adiFileName = fileInfo.getName().substring(0, fileInfo.getName().lastIndexOf(".")) + XML_EXTENSION;
            String absoluteAdiFileName = fileInfo.getAbsolutePath().substring(0, fileInfo.getAbsolutePath().lastIndexOf(".")) + XML_EXTENSION;
            boolean fileDropped = this.metadataFileArrived(absoluteAdiFileName, maxDropWaitTime = Integer.parseInt(this.getProcessProperty(MAX_DROP_WAIT_TIME_FOR_XML)), threadSleepTime);
            if (!fileDropped || !ProcessUtil.newInstance().waitTillFileCopyComplete(absoluteAdiFileName, threadSleepTime, maxCopyWaitTime)) {
                String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + absoluteAdiFileName;
                try {
                    ProcessUtil.newInstance().moveFile(fileInfo.getAbsolutePath(), failedFolder);
                }
                catch (Exception e) {
                    logger.error((Object)"Exception while moving the file to the failed folder", (Throwable)e);
                }
                logger.error((Object)errorMessage);
                this.sendAssetArrivalFailure(errorMessage);
                return;
            }
            try {
                this.loadADI(absoluteAdiFileName);
                logger.debug((Object)("The corresponding metadata file loaded: " + absoluteAdiFileName));
            }
            catch (Exception e) {
                String errorMessage = "Unable to load metadata file: " + failedFolder + adiFileName;
                logger.error((Object)errorMessage, (Throwable)e);
                try {
                    ProcessUtil.newInstance().moveFile(absoluteAdiFileName, failedFolder);
                    ProcessUtil.newInstance().moveFile(fileInfo.getAbsolutePath(), failedFolder);
                }
                catch (Exception ex) {
                    logger.error((Object)"Exception while moving the Mobile and XML files to the failed folder", (Throwable)ex);
                }
                this.sendAssetArrivalFailure(errorMessage + " | " + e.getMessage());
                return;
            }
            String copyDirPath = this.getProcessProperty(MOBILE_ORIGINAL_FOLDER) + fileInfo.getName().substring(0, fileInfo.getName().lastIndexOf(".")) + "_" + System.currentTimeMillis() + "\\";
            try {
                new File(copyDirPath).mkdir();
                ProcessUtil.newInstance().copyFile(fileInfo.getAbsolutePath(), copyDirPath);
                ProcessUtil.newInstance().copyFile(absoluteAdiFileName, copyDirPath);
            }
            catch (Exception ex) {
                String errorMessage = "Exception while copying file(s) to Mobile Original folder: " + failedFolder + fileInfo.getName();
                logger.error((Object)errorMessage, (Throwable)ex);
                try {
                    ProcessUtil.newInstance().moveFile(absoluteAdiFileName, failedFolder);
                    ProcessUtil.newInstance().moveFile(fileInfo.getAbsolutePath(), failedFolder);
                }
                catch (Exception ex2) {
                    logger.error((Object)"Exception while moving the Mobile and XML files to the failed folder", (Throwable)ex2);
                }
                this.sendAssetArrivalFailure(errorMessage + " | " + ex.getMessage());
                return;
            }
            WorkflowMessage message = null;
            try {
                message = this.prepareAASMessage(copyDirPath, adiFileName);
            }
            catch (Exception e) {
                String errorMessage = "Exception while while preparing AASMessage: " + failedFolder + fileInfo.getName();
                logger.error((Object)errorMessage, (Throwable)e);
                try {
                    ProcessUtil.newInstance().moveFile(absoluteAdiFileName, failedFolder);
                    ProcessUtil.newInstance().moveFile(fileInfo.getAbsolutePath(), failedFolder);
                }
                catch (Exception ex2) {
                    logger.error((Object)"Exception while moving the Mobile and XML files to the failed folder", (Throwable)ex2);
                }
                this.sendAssetArrivalFailure(errorMessage + " | " + e.getMessage());
                return;
            }
            try {
                Dispatcher.send(message);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to send Asset Arrival Success message to Workflow", (Throwable)e);
                return;
            }
            try {
                new File(fileInfo.getAbsolutePath()).delete();
                new File(absoluteAdiFileName).delete();
            }
            catch (Exception e) {
                logger.error((Object)("Exception in deleting the files: " + fileInfo.getAbsolutePath() + " and " + absoluteAdiFileName), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
        }
    }

    private boolean metadataFileArrived(String absoluteAdiFileName, int maxDropWaitTime, int threadSleepTime) {
        int threshold = maxDropWaitTime / threadSleepTime + 1;
        int cnt = 0;
        while (cnt++ < threshold) {
            if (new File(absoluteAdiFileName).exists()) {
                return true;
            }
            logger.debug((Object)("File Not Arrived; Sleeping for " + threadSleepTime + " seconds"));
            try {
                Thread.sleep(threadSleepTime * 1000);
            }
            catch (InterruptedException ie) {
                logger.debug((Object)"Interrupted exception caught while sleeping", (Throwable)ie);
            }
        }
        return false;
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    private void loadADI(String filePath) throws FileNotFoundException {
        this.adiParser = ADI11Parser.newInstance();
        FileInputStream in = new FileInputStream(filePath);
        this.adiParser.load(in);
    }

    private Asset getAsset(String contentType) {
        for (Asset asset : this.adiParser.extractAssets()) {
            if (!asset.getContentType().equals(contentType)) continue;
            return asset;
        }
        return null;
    }

    private String getAssetID(String contentType) {
        Asset asset = this.getAsset(contentType);
        if (asset != null) {
            return asset.getAssetId();
        }
        return null;
    }

    private String getContentFileName(String contentType) throws XPathExpressionException {
        NodeList nodes = this.adiParser.getNodes(ASSET_XPATH);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Node metadataNode = this.getChildNode(node, METADATA_NODE);
            Node amsNode = this.getChildNode(metadataNode, AMS_NODE);
            String assetClassValue = this.getAttributeValue(amsNode, AMS_ASSET_CLASS_ATTRIBUTE);
            if (assetClassValue == null || !assetClassValue.equalsIgnoreCase(contentType)) continue;
            Node contentNode = this.getChildNode(node, CONTENT_NODE);
            return this.getAttributeValue(contentNode, CONTENT_VALUE_ATTRIBUTE);
        }
        return null;
    }

    private Node getChildNode(Node node, String childNodeName) {
        NodeList childNodes = node.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            if (childNode == null || childNode.getNodeName() == null || !childNode.getNodeName().equalsIgnoreCase(childNodeName)) continue;
            return childNode;
        }
        return null;
    }

    private String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            if (attributeNode == null || attributeNode.getNodeName() == null || !attributeNode.getNodeName().equalsIgnoreCase(attributeName)) continue;
            return attributeNode.getNodeValue();
        }
        return null;
    }

    private WorkflowMessage prepareAASMessage(String copyDirPath, String adiFileName) throws Exception {
        logger.debug((Object)"Preparing AAS message");
        String packageAssetID = this.adiParser.getPackageAssetID();
        String providerID = this.adiParser.getProviderID();
        String titleBrief = this.adiParser.getPackageDescription();
        String metadataFilePath = copyDirPath + adiFileName;
        String assetID = this.getAssetID(CONTENT_TYPE_CLIP);
        String inputPath = this.getContentFileName(CONTENT_TYPE_CLIP);
        inputPath = inputPath == null ? null : copyDirPath + inputPath;
        String contentDuration = this.adiParser.getRunTime();
        logger.debug((Object)("contentDuration=" + contentDuration));
        WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProcessProperty(AAS_MESSAGE_UID)), WorkflowMessage.MessageType.control);
        message.setSource(new HTTPDevice(this.getWatchfolderProperty(SOURCE_URL)));
        message.putValue("providerId", providerID);
        message.putValue("packageAssetId", packageAssetID);
        message.putValue("metadataFilePath", metadataFilePath);
        message.putValue("titleBrief", titleBrief);
        message.putValue("contentDuration", contentDuration);
        message.putValue("assetId", assetID);
        message.putValue("inputPath", inputPath);
        return message;
    }

    private void sendAssetArrivalFailure(String errorMessage) {
        logger.debug((Object)"Sending Asset Arrival Failure message to Workflow");
        String providerID = null;
        String packageAssetID = null;
        try {
            providerID = this.adiParser.getProviderID();
            packageAssetID = this.adiParser.getPackageAssetID();
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while reading adi file");
        }
        providerID = providerID == null ? UNKNOWN_VALUE : providerID;
        packageAssetID = packageAssetID == null ? UNKNOWN_VALUE : packageAssetID;
        try {
            WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProcessProperty(AAF_MESSAGE_UID)), WorkflowMessage.MessageType.control);
            message.setSource(new HTTPDevice(this.getWatchfolderProperty(SOURCE_URL)));
            message.putValue("providerId", providerID);
            message.putValue("packageAssetId", packageAssetID);
            message.putValue("error-message", errorMessage);
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending Asset Arrival Failure messsage to Workflow", (Throwable)e);
        }
    }

    private String getWatchfolderProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }

    private String getProcessProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return MobileProcessProperties.getInstance().getProperty(propertyName);
    }
}

