/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.util.adi.Asset;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.HomePageProcess;
import com.tandbergtv.workflow.webservice.watchfolder.NonAdultVODProcess;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.RowAdProcess;
import com.tandbergtv.workflow.webservice.watchfolder.TarProcess;
import org.apache.log4j.Logger;

public class NonAdultTarProcess
extends TarProcess {
    private static final Logger logger = Logger.getLogger(NonAdultTarProcess.class);
    private static final String AAF_MESSAGE_UID = "AAFMessageUID";
    private static final String CONTENT_TYPE_CLOSED = "closed";
    private static final String CONTENT_TYPE_OPEN = "open";
    private static final String CONTENT_TYPE_COMPLETE = "complete";
    private static final String CONTENT_TYPE_BACKGROUND = "background";

    public void fileCreated(FileInfo fileInfo) {
        block8: {
            logger.info((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
            try {
                int threadSleepTime = Integer.parseInt(this.getProperty("ThreadSleepTime"));
                int maxCopyTime = Integer.parseInt(this.getProperty("MaxCopyWaitTime"));
                String failedFolder = this.getProperty("FailedFolder") + "\\";
                if (!ProcessUtil.newInstance().waitTillFileCopyComplete(fileInfo.getAbsolutePath(), threadSleepTime, maxCopyTime)) {
                    String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + fileInfo.getAbsolutePath();
                    logger.error((Object)errorMessage);
                    this.sendAssetArrivalFailure(errorMessage, AAF_MESSAGE_UID);
                    return;
                }
                String adiFileName = null;
                try {
                    adiFileName = this.getADIFileName(fileInfo.getAbsolutePath());
                    this.loadADI(fileInfo.getAbsolutePath() + "\\" + adiFileName);
                    if (this.isVODAsset()) {
                        logger.info((Object)"The asset type is VOD");
                        NonAdultVODProcess vodProcess = new NonAdultVODProcess(this.adiParser);
                        vodProcess.fileCreated(fileInfo);
                        break block8;
                    }
                    if (this.isRowAdAsset()) {
                        logger.info((Object)"The asset type is RowAd");
                        RowAdProcess rowAdProcess = new RowAdProcess(this.adiParser);
                        rowAdProcess.fileCreated(fileInfo);
                        break block8;
                    }
                    if (this.isHomePageAsset()) {
                        logger.info((Object)"The asset type is HomePage");
                        HomePageProcess homePageProcess = new HomePageProcess(this.adiParser);
                        homePageProcess.fileCreated(fileInfo);
                        break block8;
                    }
                    String errorMessage = "The asset type cannot be recognized: " + failedFolder + adiFileName;
                    logger.error((Object)errorMessage);
                    this.moveFileToFalledFolder(fileInfo, failedFolder);
                    this.sendAssetArrivalFailure(errorMessage, AAF_MESSAGE_UID);
                    return;
                }
                catch (Exception e) {
                    String errorMessage = "Unable to load metadata file from: " + failedFolder + fileInfo.getName();
                    logger.error((Object)errorMessage, (Throwable)e);
                    this.moveFileToFalledFolder(fileInfo, failedFolder);
                    this.sendAssetArrivalFailure(errorMessage + " | " + e.getMessage(), AAF_MESSAGE_UID);
                    return;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    private boolean isRowAdAsset() {
        Asset asset = this.adiParser.extractAssets().get(0);
        return asset.getContentType().equals(CONTENT_TYPE_CLOSED) || asset.getContentType().equals(CONTENT_TYPE_OPEN);
    }

    private boolean isHomePageAsset() {
        Asset asset = this.adiParser.extractAssets().get(0);
        return asset.getContentType().equals(CONTENT_TYPE_COMPLETE) || asset.getContentType().equals(CONTENT_TYPE_BACKGROUND);
    }
}

