/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.webservice.watchfolder.AbstractNonTarFilesMonitoringProcess;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import com.tandbergtv.workflow.webservice.watchfolder.NonMobileFilesProcessProperties;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class NonMobileFilesMonitoringProcess
implements IProcess {
    private static final Logger logger = Logger.getLogger(AbstractNonTarFilesMonitoringProcess.class);
    protected static final String SOURCE_URL = "SourceURL";
    protected static final String UNKNOWN_VALUE = "Unknown";
    protected static final String FAILED_FOLDER = "FailedFolder";
    private static final String AAF_MESSAGE_UID = "NonMobileFilesMonitoringProcess.AAFMessageUID";
    private static final String VALID_MOBILE_FILE_EXTENSION = "NonMobileFilesMonitoringProcess.validFileNamePattern";
    private static final String THREAD_SLEEP_TIME = "NonMobileFilesMonitoringProcess.ThreadSleepTime";
    private static final String MAX_COPY_WAIT_TIME = "NonMobileFilesMonitoringProcess.MaxCopyWaitTime";

    public void handleFailure(String errorMessage, String filePath) {
        this.sendAssetArrivalFailure(errorMessage);
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            ProcessUtil.newInstance().moveFile(filePath, failedFolder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while moving the non-mobile file to the failed folder", (Throwable)e);
        }
    }

    private void sendAssetArrivalFailure(String errorMessage) {
        logger.info((Object)"Sending Asset Arrival Failure message to Workflow");
        try {
            WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(AAF_MESSAGE_UID)), WorkflowMessage.MessageType.control);
            message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
            message.putValue("providerId", UNKNOWN_VALUE);
            message.putValue("packageAssetId", UNKNOWN_VALUE);
            message.putValue("error-message", errorMessage);
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending Asset Arrival Failure messsage to Workflow", (Throwable)e);
        }
    }

    public void fileCreated(FileInfo fileInfo) {
        logger.info((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        try {
            String regExpExtension = this.getProperty(VALID_MOBILE_FILE_EXTENSION).toLowerCase();
            if (this.isMobileOrXmlFile(fileInfo.getName(), regExpExtension)) {
                logger.debug((Object)(fileInfo.getAbsolutePath() + " is a Mobile or xml file"));
            } else {
                int threadSleepTime = Integer.parseInt(this.getProperty(THREAD_SLEEP_TIME));
                int maxCopyTime = Integer.parseInt(this.getProperty(MAX_COPY_WAIT_TIME));
                String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
                if (!ProcessUtil.newInstance().waitTillFileCopyComplete(fileInfo.getAbsolutePath(), threadSleepTime, maxCopyTime)) {
                    String errorMessage = "File not found or Max wait time for completion of file copy exceeded for: " + fileInfo.getAbsolutePath();
                    logger.error((Object)errorMessage);
                    this.sendAssetArrivalFailure(errorMessage);
                    return;
                }
                logger.info((Object)(failedFolder + fileInfo.getName() + " is not a Mobile or xml file."));
                this.handleFailure(failedFolder + fileInfo.getName() + " is not a Mobile or xml file.", fileInfo.getAbsolutePath());
            }
            return;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
            return;
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    private boolean isMobileOrXmlFile(String fileName, String regExpExtension) {
        return Pattern.matches(regExpExtension, fileName.toLowerCase()) || Pattern.matches(".*xml", fileName.toLowerCase());
    }

    protected String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return NonMobileFilesProcessProperties.getInstance().getProperty(propertyName);
    }
}

