/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class ProcessUtil {
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);
    private long size = -1L;
    private long lastModified = -1L;

    ProcessUtil() {
    }

    public static ProcessUtil newInstance() {
        return new ProcessUtil();
    }

    public boolean waitTillFileCopyComplete(String filePath, int threadSleepTime, int maxCopyTime) {
        long endTime = System.currentTimeMillis() + (long)(maxCopyTime * 1000);
        while (true) {
            try {
                if (!this.isUpdated(filePath)) {
                    logger.debug((Object)"No Update. Checking if file is intact...");
                    this.isFileIntact(filePath);
                    logger.debug((Object)"File is intact...");
                    return true;
                }
                logger.debug((Object)"File is being updated");
            }
            catch (IOException e) {
                logger.debug((Object)("IOException caught: " + e.getMessage()), (Throwable)e);
                if (!new File(filePath).exists()) {
                    logger.error((Object)"File does not exist");
                    return false;
                }
                logger.debug((Object)"File exists");
            }
            if (System.currentTimeMillis() >= endTime) break;
            logger.debug((Object)("Sleeping for " + threadSleepTime + " seconds"));
            try {
                Thread.sleep(threadSleepTime * 1000);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Interrupted exception caught while sleeping", (Throwable)e);
            }
        }
        logger.debug((Object)"Timeout");
        return false;
    }

    private boolean isUpdated(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("File: " + filePath + " does not exist");
        }
        long currentSize = file.length();
        long currentLastModified = file.lastModified();
        if (currentSize != this.size || currentLastModified != this.lastModified) {
            this.size = currentSize;
            this.lastModified = currentLastModified;
            return true;
        }
        return false;
    }

    private void isFileIntact(String filePath) throws IOException {
        FileInputStream fis = new FileInputStream(filePath);
        logger.debug((Object)"FileInputStream obtained");
        try {
            File file = new File(filePath);
            logger.debug((Object)("File Size: " + file.length()));
            logger.debug((Object)("Available Data: " + fis.available()));
            logger.debug((Object)"Skipping...");
            while (fis.available() > 0 && fis.skip(fis.available()) != 0L) {
            }
            logger.debug((Object)"Reading...");
            byte[] buffer = new byte[524288];
            while (fis.read(buffer) != -1) {
            }
            logger.debug((Object)"Finished reading till EOF...");
        }
        catch (IOException ioe) {
            logger.error((Object)("IOException caught while reading FileInputStream" + ioe));
            throw ioe;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)("IOException caught while closing FileInputStream" + e));
            }
        }
    }

    public void deleteFile(String filePath) {
        if (new File(filePath).delete()) {
            logger.debug((Object)("File: " + filePath + " is deleted"));
        } else {
            logger.error((Object)("Deletion failed for file: " + filePath));
        }
    }

    public void copyFile(String srcFilePath, String destDirectory) {
        File srcFile = new File(srcFilePath);
        File destFile = new File(destDirectory + srcFile.getName());
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(srcFile);
            }
            catch (FileNotFoundException ex) {
                String msg = "Failed to open file: " + srcFile + " for copying.";
                throw new RuntimeException(msg, ex);
            }
            try {
                out = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException ex) {
                String msg = "Cannot open destination file: " + destFile + " for copying.";
                throw new RuntimeException(msg, ex);
            }
            FileChannel inputChannel = in.getChannel();
            FileChannel outputChannel = out.getChannel();
            long maxCount = 67076096L;
            long inputChannelSize = inputChannel.size();
            for (long position = 0L; position < inputChannelSize; position += inputChannel.transferTo(position, maxCount, outputChannel)) {
            }
        }
        catch (IOException ioe) {
            String msg = "Failed while copying the contents of file: " + srcFile + " to destination: " + destFile;
            throw new RuntimeException(msg, ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to close input stream for file: " + srcFile + " after reading the file contents."), (Throwable)ioe);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to close output stream for file: " + destFile + " after writing the copied file contents."), (Throwable)ioe);
                }
            }
        }
        logger.info((Object)("Copied File: " + srcFile.getAbsolutePath() + " to: " + destFile.getAbsolutePath()));
    }

    public void moveFile(String srcFilePath, String destDirectory) {
        this.copyFile(srcFilePath, destDirectory);
        this.deleteFile(srcFilePath);
    }
}

