/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor {
    private static final Logger logger = Logger.getLogger(Processor.class);
    private static final int DELETED = 0;
    private static final int CREATED = 1;
    private static final int MODIFIED = 2;
    private static final int DEFAULT_NUM_THREADS = 1;
    private static final String ALL_EVENTS = "create,update,delete";
    private static final String CREATE_EVENT = "create";
    private static final String UPDATE_EVENT = "update";
    private static final String DELETE_EVENT = "delete";
    private String processClassName;
    private int numThreads;
    private List<String> eventList = new ArrayList<String>();
    private Map<String, String> parameterList = new HashMap<String, String>();
    Set<FileInfo> createdFiles = new HashSet<FileInfo>();
    Set<FileInfo> deletedFiles = new HashSet<FileInfo>();
    Set<FileInfo> modifiedFiles = new HashSet<FileInfo>();
    private ExecutorService execService;

    Processor(String processClassName, Map<String, String> parameterList) {
        this(processClassName, 1, ALL_EVENTS, parameterList);
    }

    Processor(String processClassName, int numThreads, String events, Map<String, String> parameterList) {
        this.processClassName = processClassName.trim();
        this.numThreads = numThreads;
        this.parameterList = parameterList;
        this.execService = Executors.newFixedThreadPool(numThreads);
        if (events == null) {
            events = ALL_EVENTS;
        }
        StringTokenizer st = new StringTokenizer(events, ",");
        while (st.hasMoreTokens()) {
            String event = st.nextToken().trim();
            this.eventList.add(event);
        }
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public String getProcessClassName() {
        return this.processClassName;
    }

    public void setProcessClassName(String processClassName) {
        this.processClassName = processClassName;
    }

    public void addCreatedFiles(Set<FileInfo> files) {
        if (this.eventList.contains(CREATE_EVENT)) {
            this.createdFiles.addAll(files);
        }
    }

    public void addDeletedFiles(Set<FileInfo> files) {
        if (this.eventList.contains(DELETE_EVENT)) {
            this.deletedFiles.addAll(files);
        }
    }

    public void addModifiedFiles(Set<FileInfo> files) {
        if (this.eventList.contains(UPDATE_EVENT)) {
            this.modifiedFiles.addAll(files);
        }
    }

    private void clearFileLists() {
        this.deletedFiles.clear();
        this.createdFiles.clear();
        this.modifiedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyProcessor() {
        if (this.createdFiles.isEmpty() && this.deletedFiles.isEmpty() && this.modifiedFiles.isEmpty()) {
            return;
        }
        logger.debug((Object)("Process: " + this.getProcessClassName() + " Adding " + (this.createdFiles.size() + this.deletedFiles.size() + this.modifiedFiles.size()) + " ProcessTask(s) to Executor Service"));
        try {
            for (FileInfo fileInfo : this.createdFiles) {
                this.execService.execute(new ProcessTask(this.processClassName, fileInfo, 1, this.parameterList));
            }
            for (FileInfo fileInfo : this.modifiedFiles) {
                this.execService.execute(new ProcessTask(this.processClassName, fileInfo, 2, this.parameterList));
            }
            for (FileInfo fileInfo : this.deletedFiles) {
                this.execService.execute(new ProcessTask(this.processClassName, fileInfo, 0, this.parameterList));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while submitting process task to executor service", (Throwable)e);
        }
        finally {
            logger.debug((Object)("Clearing the file lists for process: " + this.getProcessClassName()));
            this.clearFileLists();
        }
    }

    public synchronized void shutdown() {
        logger.info((Object)("Shutdown called for Process: " + this.getProcessClassName() + ". Forcing shutdown on Executor Service."));
        try {
            this.execService.shutdownNow();
        }
        catch (Exception e) {
            logger.error((Object)("Exception while shutting down executor service for process: " + this.getProcessClassName()));
            return;
        }
        logger.info((Object)"Executor Service shutdown.");
    }

    public Map<String, String> getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(Map<String, String> parameterList) {
        this.parameterList = parameterList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessTask
    implements Runnable {
        IProcess process;
        FileInfo fileInfo;
        int change;

        ProcessTask(String processClassName, FileInfo fileInfo, int change, Map<String, String> parameterList) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            logger.debug((Object)("ProcessTask constructor:  processClassName: " + processClassName + " fileInfo's absolutePath: " + fileInfo.getAbsolutePath() + " change: " + change));
            this.process = this.createInstance(processClassName, parameterList);
            this.fileInfo = fileInfo;
            this.change = change;
        }

        public IProcess createInstance(String processClassName, Map<String, String> parameterList) {
            IProcess process = null;
            try {
                Constructor<?>[] allConstructors;
                Class<?> paramType = Class.forName("java.util.Map");
                Class<?> myClass = Class.forName(processClassName);
                for (Constructor<?> ctor : allConstructors = myClass.getDeclaredConstructors()) {
                    Class<?>[] pType = ctor.getParameterTypes();
                    for (int i = 0; i < pType.length; ++i) {
                        if (!pType[i].equals(paramType) || pType.length != 1) continue;
                        logger.debug((Object)("Creating Instance with argument as Map " + processClassName));
                        return (IProcess)ctor.newInstance(parameterList);
                    }
                }
                logger.debug((Object)("Creating Instance without argument " + processClassName));
                return (IProcess)Class.forName(processClassName).newInstance();
            }
            catch (Throwable t) {
                logger.error((Object)"Throwable caught while creating the instance of a process", t);
                return process;
            }
        }

        @Override
        public void run() {
            switch (this.change) {
                case 0: {
                    try {
                        this.process.fileDeleted(this.fileInfo);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Throwable caught while calling the process's fileDeleted() method", t);
                    }
                    break;
                }
                case 1: {
                    try {
                        this.process.fileCreated(this.fileInfo);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Throwable caught while calling the process's fileCreated() method", t);
                    }
                    break;
                }
                case 2: {
                    try {
                        this.process.fileUpdated(this.fileInfo);
                        break;
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Throwable caught while calling the process's fileModified() method", t);
                    }
                }
            }
        }
    }
}

