/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.adi.ADI11Parser;
import com.tandbergtv.workflow.util.adi.Asset;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.TarUtil;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import org.apache.log4j.Logger;

public abstract class TarProcess
implements IProcess {
    private static final Logger logger = Logger.getLogger(TarProcess.class);
    protected static final String SOURCE_URL = "SourceURL";
    protected static final String THREAD_SLEEP_TIME = "ThreadSleepTime";
    protected static final String MAX_COPY_WAIT_TIME = "MaxCopyWaitTime";
    protected static final String FAILED_FOLDER = "FailedFolder";
    protected static final String ADI_FILE_NAME = "ADIFileName";
    protected static final String UNKNOWN_VALUE = "Unknown";
    protected static final String CONTENT_TYPE_MOVIE = "movie";
    protected static final String CONTENT_TYPE_PREVIEW = "preview";
    protected static final String CONTENT_TYPE_POSTER = "poster";
    protected ADI11Parser adiParser;

    protected String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }

    protected String getADIFileName(String filePath) throws Exception {
        String adiFileNameFromProps = this.getProperty(ADI_FILE_NAME);
        String[] files = TarUtil.getInstance().list(filePath);
        if (files != null) {
            for (String fileName : files) {
                if (fileName == null || !fileName.equalsIgnoreCase(adiFileNameFromProps)) continue;
                return fileName;
            }
        }
        throw new Exception("ADI File could not be found in " + filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadADI(String filePath) throws FileNotFoundException {
        try {
            this.adiParser = ADI11Parser.newInstance();
            InputStream in = TarUtil.getInstance().getInputStream(filePath);
            this.adiParser.load(in);
        }
        finally {
            TarUtil.getInstance().unmount(filePath);
        }
    }

    protected boolean isVODAsset() {
        Asset asset = this.adiParser.extractAssets().get(0);
        return asset.getContentType().equals(CONTENT_TYPE_MOVIE) || asset.getContentType().equals(CONTENT_TYPE_POSTER) || asset.getContentType().equals(CONTENT_TYPE_PREVIEW);
    }

    protected void sendAssetArrivalFailure(String errorMessage, String constantAAF) {
        logger.debug((Object)"Sending Asset Arrival Failure message to Workflow");
        String providerID = null;
        String packageAssetID = null;
        try {
            providerID = this.adiParser.getProviderID();
            packageAssetID = this.adiParser.getPackageAssetID();
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while reading adi file");
        }
        providerID = providerID == null ? UNKNOWN_VALUE : providerID;
        packageAssetID = packageAssetID == null ? UNKNOWN_VALUE : packageAssetID;
        try {
            WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(constantAAF)), WorkflowMessage.MessageType.control);
            message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
            message.putValue("providerId", providerID);
            message.putValue("packageAssetId", packageAssetID);
            message.putValue("error-message", errorMessage);
            message.setCommand(new WPCLCommand("create"));
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending Asset Arrival Failure messsage to Workflow", (Throwable)e);
        }
    }

    protected void moveFileToFalledFolder(FileInfo fileInfo, String failedFolder) {
        try {
            ProcessUtil.newInstance().moveFile(fileInfo.getAbsolutePath(), failedFolder);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception while moving the TAR file to the failed folder", (Throwable)ex);
        }
    }
}

