/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class TarUtil {
    private static final Logger logger = Logger.getLogger(TarUtil.class);
    private static TarUtil _instance = null;

    private TarUtil() {
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)ArchiveDetector.ALL);
    }

    public static synchronized TarUtil getInstance() {
        if (_instance == null) {
            _instance = new TarUtil();
        }
        return _instance;
    }

    public String[] list(String filePath) {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(filePath);
        String[] filesList = file.list();
        this.unmount(filePath);
        return filesList;
    }

    public void printList(String filePath) {
        de.schlichtherle.io.File file = null;
        file = new de.schlichtherle.io.File(filePath);
        String[] members = file.list();
        logger.debug((Object)("Members of the " + file.getName() + " are: "));
        for (String memberName : members) {
            logger.debug((Object)memberName);
        }
        this.unmount(filePath);
    }

    public void unpack(String filePath, String outputDirectory) {
        new de.schlichtherle.io.File(filePath).copyAllTo((File)new de.schlichtherle.io.File(outputDirectory));
        this.unmount(filePath);
    }

    public InputStream getInputStream(String filePath) throws FileNotFoundException {
        return new FileInputStream(filePath);
    }

    public void unmount(String filePath) {
        logger.debug((Object)("Unmounting " + filePath));
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(filePath);
        if (file.isArchive() && file.getEnclArchive() == null && file.isDirectory()) {
            try {
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception while unmounting file: " + filePath), (Throwable)e);
            }
        }
    }
}

