/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.IProcess;
import org.apache.log4j.Logger;

public class TestProcess
implements IProcess {
    private static Logger logger = Logger.getLogger(TestProcess.class);

    public void fileCreated(FileInfo fileInfo) {
        this.print(fileInfo.getAbsolutePath(), "created");
        this.sleep();
    }

    public void fileUpdated(FileInfo fileInfo) {
        this.print(fileInfo.getAbsolutePath(), "updated");
        this.sleep();
    }

    public void fileDeleted(FileInfo fileInfo) {
        this.print(fileInfo.getAbsolutePath(), "deleted");
        this.sleep();
    }

    public void init() {
        logger.info((Object)"TestProcessor initialized");
    }

    private void print(String filePath, String type) {
        logger.info((Object)(this.getClass().getSimpleName() + " received " + type + " event for " + filePath));
    }

    private void sleep() {
        try {
            logger.info((Object)"Sleeping...");
            Thread.sleep(40000L);
            logger.info((Object)"Awoke...");
        }
        catch (InterruptedException e) {
            logger.error((Object)"Exception while sleeping", (Throwable)e);
        }
    }

    private void sendTestMessage() {
        try {
            WorkflowMessage message = WorkflowMessageFactory.createControlMessage("TEST_UID");
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending the message", (Throwable)e);
        }
    }
}

