/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.amsadi.AMSADIManager;
import com.tandbergtv.amsadi.AmsAdiException;
import com.tandbergtv.amsadi.ProvisionProfile;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.adi.ADI11Parser;
import com.tandbergtv.workflow.webservice.watchfolder.Dispatcher;
import com.tandbergtv.workflow.webservice.watchfolder.FileInfo;
import com.tandbergtv.workflow.webservice.watchfolder.ProcessUtil;
import com.tandbergtv.workflow.webservice.watchfolder.TarUtil;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderProperties;
import java.io.File;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import org.apache.log4j.Logger;

public abstract class VODProcess {
    private static final Logger logger = Logger.getLogger(VODProcess.class);
    private static final String SOURCE_URL = "SourceURL";
    private static final String UNKNOWN_VALUE = "Unknown";
    private static final String AAF_MESSAGE_UID = "AAFMessageUID";
    private static final String ADI_VERSION = "ADIVersion";
    private static final String ADI_VOD_SPEC_VERSION = "ADIVODSpecVersion";
    private static final String AMS_SERVER_IP = "AMSServerIP";
    private static final String AMS_PORT = "AMSPort";
    private static final String FTP_SERVER_IP = "FTPServerIP";
    private static final String FTP_USERNAME = "FTPUsername";
    private static final String FTP_PASSWORD = "FTPPassword";
    private static final String FTP_ROOT_DIR = "FTPRootDir";
    private static final String FTP_TEMP_DIR = "TempDir";
    private static final String FAILED_FOLDER = "FailedFolder";
    private ADI11Parser adiParser;

    public VODProcess() {
    }

    public VODProcess(ADI11Parser adiParser) {
        this.adiParser = adiParser;
    }

    public void fileCreated(FileInfo fileInfo) {
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            String packageDir = "\\" + this.getVODProperty(FTP_TEMP_DIR) + "\\" + fileInfo.getName() + "_" + System.currentTimeMillis();
            String explodedDirPath = this.getVODProperty(FTP_ROOT_DIR) + packageDir;
            try {
                logger.info((Object)("Untarring " + fileInfo.getAbsolutePath() + " to " + explodedDirPath));
                TarUtil.getInstance().unpack(fileInfo.getAbsolutePath(), explodedDirPath);
            }
            catch (Exception e) {
                String errorMessage = "Exception while untarring file: " + failedFolder + fileInfo.getName();
                logger.error((Object)errorMessage, (Throwable)e);
                this.handleFailure(errorMessage + " | " + e.getMessage(), fileInfo.getAbsolutePath());
                return;
            }
            logger.info((Object)("Starting package provisioning from: " + explodedDirPath));
            ProvisionProfile profile = new ProvisionProfile();
            profile.setAdiVersion(this.getVODProperty(ADI_VERSION));
            profile.setAdiVODSpecVersion(this.getVODProperty(ADI_VOD_SPEC_VERSION));
            profile.setAmsPort(this.getVODProperty(AMS_PORT));
            profile.setAmsServerIP(this.getVODProperty(AMS_SERVER_IP));
            profile.setFtpServerIP(this.getVODProperty(FTP_SERVER_IP));
            profile.setFtpUsername(this.getVODProperty(FTP_USERNAME));
            profile.setFtpPassword(this.getVODProperty(FTP_PASSWORD));
            profile.setPackagedir(packageDir);
            AMSADIManager manager = new AMSADIManager(profile);
            try {
                manager.provisionPackage();
                logger.info((Object)("Completed package provisioning for " + explodedDirPath));
            }
            catch (AmsAdiException e) {
                String errorMessage = "Exception occurred while provisioning package for " + failedFolder + fileInfo.getName() + ": " + e.getMessage();
                logger.error((Object)errorMessage, (Throwable)e);
                this.handleFailure(errorMessage, fileInfo.getAbsolutePath());
                this.deleteTempFolder(fileInfo, explodedDirPath);
                return;
            }
            try {
                ProcessUtil.newInstance().deleteFile(fileInfo.getAbsolutePath());
            }
            catch (Exception e) {
                logger.error((Object)("Exception in deleting the tar file: " + fileInfo.getAbsolutePath()), (Throwable)e);
            }
            this.deleteTempFolder(fileInfo, explodedDirPath);
        }
        catch (Exception e) {
            logger.error((Object)("Exception while processing fileCreated event for: " + fileInfo.getAbsolutePath()), (Throwable)e);
        }
    }

    private void deleteTempFolder(FileInfo fileInfo, String explodedDirPath) {
        try {
            File dir = new File(explodedDirPath);
            this.deleteFileOrDirectory(dir);
        }
        catch (Exception e) {
            logger.error((Object)("Exception in deleting the tar file: " + fileInfo.getAbsolutePath()), (Throwable)e);
        }
    }

    private void deleteFileOrDirectory(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (file.isFile()) {
                        file.delete();
                        continue;
                    }
                    this.deleteFileOrDirectory(file);
                    file.delete();
                }
            }
            dir.delete();
        }
    }

    private void handleFailure(String errorMessage, String filePath) {
        logger.debug((Object)"Sending Asset Arrival Failure message to Workflow");
        String providerID = null;
        String packageAssetID = null;
        try {
            providerID = this.adiParser.getProviderID();
            packageAssetID = this.adiParser.getPackageAssetID();
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while reading adi file");
        }
        providerID = providerID == null ? UNKNOWN_VALUE : providerID;
        packageAssetID = packageAssetID == null ? UNKNOWN_VALUE : packageAssetID;
        try {
            WorkflowMessage message = new WorkflowMessage((IMessageUID)new MessageUIDImpl(this.getProperty(AAF_MESSAGE_UID)), WorkflowMessage.MessageType.control);
            message.setSource(new HTTPDevice(this.getProperty(SOURCE_URL)));
            message.putValue("providerId", providerID);
            message.putValue("packageAssetId", packageAssetID);
            message.putValue("error-message", errorMessage);
            Dispatcher.send(message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending Asset Arrival Failure messsage to Workflow", (Throwable)e);
        }
        try {
            String failedFolder = this.getProperty(FAILED_FOLDER) + "\\";
            ProcessUtil.newInstance().moveFile(filePath, failedFolder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while moving the tar file to the failed folder", (Throwable)e);
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    protected abstract String getVODProperty(String var1) throws InvalidPropertiesFormatException, IOException;

    private String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }
}

