/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.webservice.watchfolder;

import com.tandbergtv.workflow.webservice.watchfolder.DirectoryEntry;
import com.tandbergtv.workflow.webservice.watchfolder.WatchfolderConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WatchfolderConfigurationReader {
    private static final String WATCHFOLDER_CONFIG_FILE = "watchfolder.xml";
    private static final String DIRECTORY_PATH = "//directories/directory";
    private static final String PATH = "path";
    private static final String FILTER = "filter";
    private static final String FREQUENCY = "frequency";
    private static final String PROCESS = "process";
    private static final String PARAMETER_LIST = "parameterList";
    private static final String PARAMETER = "parameter";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_VALUE = "value";
    private static final String CLASS_NAME = "class";
    private static final String NUM_THREADS = "threads";
    private static final String EVENTS = "events";
    private static final Logger logger = Logger.getLogger(WatchfolderConfigurationReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchfolderConfiguration readConfiguration() {
        WatchfolderConfiguration configuration = new WatchfolderConfiguration();
        String prefix = this.getClass().getPackage().getName();
        String resource = prefix.replace('.', '/') + "/" + WATCHFOLDER_CONFIG_FILE;
        InputStream configStream = null;
        Document configDoc = null;
        try {
            configStream = this.getClass().getClassLoader().getResourceAsStream(resource);
            configDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(configStream);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read configuration file - watchfolder.xml, maybe you haven't bundled it in the JAR?", (Throwable)e);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to parse configuration file - watchfolder.xml", (Throwable)ex);
        }
        finally {
            try {
                if (configStream != null) {
                    configStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while closing the stream", (Throwable)e);
            }
        }
        if (configDoc != null) {
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList directories = (NodeList)xpath.evaluate(DIRECTORY_PATH, configDoc, XPathConstants.NODESET);
                logger.debug((Object)("directories.size=" + directories.getLength()));
                ArrayList<DirectoryEntry> dirList = new ArrayList<DirectoryEntry>();
                for (int index = 0; index < directories.getLength(); ++index) {
                    Element directory = (Element)directories.item(index);
                    Element process = WatchfolderConfigurationReader.getChildElement(directory, PROCESS);
                    Element parameterList = WatchfolderConfigurationReader.getChildElement(process, PARAMETER_LIST);
                    String dirName = directory.getAttribute(PATH);
                    String filter = WatchfolderConfigurationReader.getChildElement(directory, FILTER).getTextContent();
                    int frequency = Integer.parseInt(WatchfolderConfigurationReader.getChildElement(directory, FREQUENCY).getTextContent());
                    String processClass = WatchfolderConfigurationReader.getChildElement(process, CLASS_NAME).getTextContent().trim();
                    HashMap<String, String> paramList = new HashMap<String, String>();
                    if (parameterList != null) {
                        NodeList paraList = parameterList.getElementsByTagName(PARAMETER);
                        for (int i = 0; i < paraList.getLength(); ++i) {
                            String parName = this.getAttributeValue(paraList.item(i), PARAM_NAME);
                            String parValue = this.getAttributeValue(paraList.item(i), PARAM_VALUE);
                            paramList.put(parName, parValue);
                        }
                    }
                    int numThreads = Integer.parseInt(WatchfolderConfigurationReader.getChildElement(directory, NUM_THREADS).getTextContent());
                    String events = WatchfolderConfigurationReader.getChildElement(directory, EVENTS).getTextContent().toLowerCase();
                    if (numThreads < 1) {
                        numThreads = 1;
                    }
                    DirectoryEntry dir = new DirectoryEntry(dirName, filter, frequency, processClass, numThreads, events);
                    dir.setParameterList(paramList);
                    dirList.add(dir);
                }
                configuration.setDirectories(dirList);
            }
            catch (XPathExpressionException e) {
                logger.error((Object)"Exception while xpathing...", (Throwable)e);
            }
        }
        return configuration;
    }

    private static Element getChildElement(Element element, String childElementName) {
        NodeList list = element.getElementsByTagName(childElementName);
        return (Element)list.item(0);
    }

    private String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            if (attributeNode == null || attributeNode.getNodeName() == null || !attributeNode.getNodeName().equalsIgnoreCase(attributeName)) continue;
            return attributeNode.getNodeValue();
        }
        return null;
    }
}

