/*
 * Decompiled with CFR 0.152.
 */
package com.tandberg.XportWebServices;

import com.tandberg.ReEncodeClient.ReEncode;
import com.tandberg.ReEncodeClient.ReEncodeServiceLocator;
import com.tandberg.XportWebServicesClient.MPEGProperties;
import com.tandberg.XportWebServicesClient.MPEGPropertiesServiceLocator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.rpc.ServiceException;

public class TestClient
extends JFrame {
    protected JTextField validatetf;
    protected JTextField propstf;
    protected JTextField sourcetf;
    protected JTextField desttf;
    protected JTextField idtf;
    protected JTextField urltf;
    protected JTextArea ta;

    public TestClient() {
        this.createScreen();
    }

    private void createScreen() {
        this.setTitle("Xport WebServices Demo");
        TestClient.setDefaultLookAndFeelDecorated(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints maingbc = new GridBagConstraints();
        JPanel urlpanel = new JPanel();
        urlpanel.setBorder(BorderFactory.createTitledBorder("URL"));
        urlpanel.setLayout(new GridBagLayout());
        JLabel urllabel = new JLabel("URL");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        urlpanel.add((Component)urllabel, gbc);
        this.urltf = new JTextField("address:port");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        urlpanel.add((Component)this.urltf, gbc);
        maingbc.gridx = 0;
        maingbc.gridy = 0;
        maingbc.fill = 2;
        maingbc.weightx = 100.0;
        maingbc.weighty = 0.0;
        maingbc.gridheight = 1;
        maingbc.gridwidth = 1;
        this.add((Component)urlpanel, maingbc);
        JPanel validatePanel = new JPanel();
        validatePanel.setBorder(BorderFactory.createTitledBorder("Validation Demo"));
        GridBagLayout gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        validatePanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        JLabel label = new JLabel("File: ");
        validatePanel.add((Component)label, gbc);
        this.validatetf = new JTextField();
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.validatetf.setSize(200, 15);
        validatePanel.add((Component)this.validatetf, gbc);
        JButton browse = new JButton("Browse");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        validatePanel.add((Component)browse, gbc);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestClient.this.BrowseAction(TestClient.this.validatetf);
            }
        });
        JButton validate = new JButton("Validate");
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        validatePanel.add((Component)validate, gbc);
        validate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestClient.this.validateAction(TestClient.this.validatetf.getText().trim());
            }
        });
        maingbc.gridx = 0;
        maingbc.gridy = 1;
        maingbc.fill = 2;
        maingbc.weightx = 100.0;
        maingbc.weighty = 0.0;
        maingbc.gridheight = 1;
        maingbc.gridwidth = 1;
        this.add((Component)validatePanel, maingbc);
        JPanel PropertiesPanel = new JPanel();
        PropertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties Demo"));
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        PropertiesPanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        label = new JLabel("File: ");
        PropertiesPanel.add((Component)label, gbc);
        this.propstf = new JTextField();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        PropertiesPanel.add((Component)this.propstf, gbc);
        browse = new JButton("Browse");
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        PropertiesPanel.add((Component)browse, gbc);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestClient.this.BrowseAction(TestClient.this.propstf);
            }
        });
        JButton propsButton = new JButton("Get MPEG Properties");
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        PropertiesPanel.add((Component)propsButton, gbc);
        propsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestClient.this.propsAction(TestClient.this.propstf.getText().trim());
            }
        });
        maingbc.gridx = 0;
        maingbc.gridy = 2;
        maingbc.fill = 2;
        maingbc.weightx = 100.0;
        maingbc.weighty = 0.0;
        maingbc.gridheight = 1;
        maingbc.gridwidth = 1;
        this.add((Component)PropertiesPanel, maingbc);
        JPanel encodePanel = new JPanel();
        encodePanel.setBorder(BorderFactory.createTitledBorder("Re-encode Demo"));
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        encodePanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        label = new JLabel("Xport ID: ");
        encodePanel.add((Component)label, gbc);
        this.idtf = new JTextField();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)this.idtf, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        label = new JLabel("Source File: ");
        encodePanel.add((Component)label, gbc);
        this.sourcetf = new JTextField();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)this.sourcetf, gbc);
        browse = new JButton("Browse");
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)browse, gbc);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestClient.this.BrowseAction(TestClient.this.sourcetf);
            }
        });
        label = new JLabel("   Dest File: ");
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)label, gbc);
        this.desttf = new JTextField();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)this.desttf, gbc);
        browse = new JButton("Browse");
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)browse, gbc);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestClient.this.BrowseAction(TestClient.this.desttf);
            }
        });
        JButton encodeButton = new JButton("ReEncode");
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        encodePanel.add((Component)encodeButton, gbc);
        encodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String id = TestClient.this.idtf.getText().trim();
                id = TestClient.this.idtf.getText().trim();
                if (id.length() == 0) {
                    JOptionPane.showMessageDialog(new JFrame(), "The Xport ID must be a number.", "Xport ID Error", 0);
                    return;
                }
                TestClient.this.encodeAction(id, TestClient.this.sourcetf.getText().trim(), TestClient.this.desttf.getText().trim());
            }
        });
        maingbc.gridx = 0;
        maingbc.gridy = 3;
        maingbc.fill = 2;
        maingbc.weightx = 100.0;
        maingbc.weighty = 0.0;
        maingbc.gridheight = 1;
        maingbc.gridwidth = 1;
        this.add((Component)encodePanel, maingbc);
        ScrollPane sp = new ScrollPane();
        sp.setSize(500, 300);
        JPanel taPanel = new JPanel();
        taPanel.setBorder(BorderFactory.createTitledBorder("Demo Output"));
        taPanel.setLayout(new GridBagLayout());
        this.ta = new JTextArea();
        this.ta.setSize(800, 300);
        sp.add(this.ta);
        gbc = new GridBagConstraints();
        taPanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        taPanel.add((Component)sp, gbc);
        maingbc.gridx = 0;
        maingbc.gridy = 4;
        maingbc.fill = 1;
        maingbc.weightx = 100.0;
        maingbc.weighty = 100.0;
        maingbc.gridheight = 5;
        maingbc.gridwidth = 1;
        this.add((Component)taPanel, maingbc);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((int)((dim.getWidth() - 900.0) / 2.0), (int)((dim.getHeight() - 600.0) / 2.0), 900, 600);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    private void BrowseAction(JTextField pathtf) {
        JFileChooser chooser = new JFileChooser(pathtf.getText());
        chooser.setFileSelectionMode(2);
        chooser.setDialogType(0);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            pathtf.setText(file.toString());
        }
    }

    private void validateAction(String filename) {
        try {
            String addrport = this.urltf.getText().trim();
            URL url = new URL("http://" + addrport + "/axis/services/MPEGProperties");
            MPEGPropertiesServiceLocator ps = new MPEGPropertiesServiceLocator();
            MPEGProperties props = ps.getMPEGProperties(url);
            String errorMsgs = props.validate(filename);
            if (errorMsgs.length() > 0) {
                this.ta.append(errorMsgs + "\n");
            } else {
                this.ta.append("The file is valid.\n");
            }
            this.ta.repaint();
        }
        catch (MalformedURLException me) {
            this.ta.append(me.getLocalizedMessage() + "\n");
            this.ta.repaint();
            me.printStackTrace();
        }
        catch (ServiceException me) {
            this.ta.append(me.getLocalizedMessage() + "\n");
            this.ta.repaint();
            me.printStackTrace();
        }
        catch (RemoteException re) {
            this.ta.append(re.getLocalizedMessage() + "\n");
            this.ta.repaint();
            re.printStackTrace();
        }
    }

    private void propsAction(final String filename) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String addrport = TestClient.this.urltf.getText().trim();
                    URL url = new URL("http://" + addrport + "/axis/services/MPEGProperties");
                    MPEGPropertiesServiceLocator ps = new MPEGPropertiesServiceLocator();
                    MPEGProperties props = ps.getMPEGProperties(url);
                    TestClient.this.ta.append("IS MPEG2: " + props.isMPEG2(filename) + "\n");
                    TestClient.this.ta.repaint();
                    TestClient.this.ta.append("IS MPEG4: " + props.isMPEG4(filename) + "\n");
                    TestClient.this.ta.repaint();
                    TestClient.this.ta.append("PMT PID: " + props.getPMTPid(filename) + "\n");
                    TestClient.this.ta.append("PCR PID: " + props.getPCRPid(filename) + "\n");
                    TestClient.this.ta.append("VIDEO PID: " + props.getVideoPid(filename) + "\n");
                    TestClient.this.ta.repaint();
                    TestClient.this.ta.append("VIDEO RESOLUTION: " + props.getResolution(filename) + "\n");
                    TestClient.this.ta.append("VIDEO ASPECT RATIO: " + props.getAspectRatio(filename) + "\n");
                    TestClient.this.ta.append("Encoding Type: " + props.getEncodingType(filename) + "\n");
                    TestClient.this.ta.append("Frame Rate: " + props.getFrameRate(filename) + "\n");
                    TestClient.this.ta.repaint();
                    TestClient.this.ta.append("GOP Length: " + props.getGOPLength(filename) + "\n");
                    TestClient.this.ta.append("GOP Structure: " + props.getGOPStructure(filename) + "\n");
                    TestClient.this.ta.append("Run Time: " + props.getRunTime(filename) + "\n");
                    TestClient.this.ta.append("Transport Rate: " + props.getTransportRate(filename) + "\n");
                    TestClient.this.ta.append("Is Variable GOP: " + props.isVariableGOP(filename) + "\n");
                    TestClient.this.ta.repaint();
                    TestClient.this.ta.append("has CC: " + props.hasCC(filename) + "\n");
                    TestClient.this.ta.append("VIDEO Bit Rate: " + props.getVideoRate(filename) + "\n");
                    TestClient.this.ta.append("Is Constant Bit Rate: " + props.isConstantBitRate(filename) + "\n");
                    TestClient.this.ta.append("Is Drop Frame: " + props.isDropFrame(filename) + "\n");
                    TestClient.this.ta.append("Is  HD: " + props.isHD(filename) + "\n");
                    TestClient.this.ta.repaint();
                    TestClient.this.ta.append("AUDIO MODES: " + props.getAudioModes(filename) + "\n");
                    TestClient.this.ta.append("Properties Map: " + props.getMPEGProperties(filename) + "\n");
                    TestClient.this.ta.append("Needs Re-encoding: " + props.needsReEncoding(filename) + "\n");
                    TestClient.this.ta.repaint();
                }
                catch (MalformedURLException me) {
                    TestClient.this.ta.append(me.getLocalizedMessage() + "\n");
                    me.printStackTrace();
                }
                catch (ServiceException me) {
                    TestClient.this.ta.append(me.getLocalizedMessage() + "\n");
                    me.printStackTrace();
                }
                catch (RemoteException re) {
                    TestClient.this.ta.append(re.getLocalizedMessage() + "\n");
                    re.printStackTrace();
                }
            }
        };
        new Thread(r).start();
    }

    private void encodeAction(final String id_, final String source, final String dest) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String addrport = TestClient.this.urltf.getText().trim();
                    URL url = new URL("http://" + addrport + "/axis/services/ReEncode");
                    ReEncodeServiceLocator rs = new ReEncodeServiceLocator();
                    ReEncode rc = rs.getReEncode(url);
                    String id = rc.reEncode(id_, source, dest);
                    id = rc.getXportID();
                    TestClient.this.ta.append("id is " + id + "\n");
                    TestClient.this.ta.append("Encoding");
                    while (!rc.isComplete()) {
                        Thread.sleep(1000L);
                        TestClient.this.ta.append(".");
                        TestClient.this.ta.repaint();
                    }
                    TestClient.this.ta.append("\n");
                    if (rc.getErrorMessage().length() == 0) {
                        TestClient.this.ta.append("SUCCESS! No Errors!\n");
                    } else {
                        TestClient.this.ta.append("ERROR: Error Message is: " + rc.getErrorMessage());
                    }
                }
                catch (InterruptedException ie) {
                    TestClient.this.ta.append(ie.getLocalizedMessage() + "\n");
                    ie.printStackTrace();
                }
                catch (MalformedURLException me) {
                    TestClient.this.ta.append(me.getLocalizedMessage() + "\n");
                    me.printStackTrace();
                }
                catch (ServiceException me) {
                    TestClient.this.ta.append(me.getLocalizedMessage() + "\n");
                    me.printStackTrace();
                }
                catch (RemoteException re) {
                    TestClient.this.ta.append(re.getLocalizedMessage() + "\n");
                    re.printStackTrace();
                }
            }
        };
        new Thread(r).start();
    }

    public static void main(String[] argv) {
        TestClient tc = new TestClient();
    }
}

