/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.commons.data;

import com.n2bb.commons.data.ValidatedObject;

public class Range
implements ValidatedObject {
    private Object floor;
    private Object ceiling;
    private Object value;

    public Range() {
    }

    public Range(Integer n, Integer n2) {
        this.floor = n;
        this.ceiling = n2;
    }

    public Range(Integer n, Integer n2, Integer n3) {
        this(n, n2);
        this.value = n3;
    }

    public Range(Float f, Float f2) {
        this.floor = f;
        this.ceiling = f2;
    }

    public Range(Float f, Float f2, Float f3) {
        this(f, f2);
        this.value = f3;
    }

    public Range(Double d, Double d2) {
        this.floor = d;
        this.ceiling = d2;
    }

    public Range(Double d, Double d2, Double d3) {
        this(d, d2);
        this.value = d3;
    }

    public boolean validate() {
        if (this.floor == null || this.ceiling == null || this.value == null) {
            return false;
        }
        if (this.floor instanceof Integer || this.ceiling instanceof Integer || this.value instanceof Integer) {
            return (Integer)this.floor <= (Integer)this.ceiling && (Integer)this.floor <= (Integer)this.value && (Integer)this.value <= (Integer)this.ceiling;
        }
        if (this.floor instanceof Float || this.ceiling instanceof Float || this.value instanceof Float) {
            return !(((Float)this.floor).floatValue() > ((Float)this.ceiling).floatValue()) && !(((Float)this.floor).floatValue() > ((Float)this.value).floatValue()) && !(((Float)this.value).floatValue() > ((Float)this.ceiling).floatValue());
        }
        if (this.floor instanceof Double || this.ceiling instanceof Double || this.value instanceof Double) {
            return !((Double)this.floor > (Double)this.ceiling) && !((Double)this.floor > (Double)this.value) && !((Double)this.value > (Double)this.ceiling);
        }
        return false;
    }

    public String toString() {
        return this.floor + " <= " + this.value + " <= " + this.ceiling + " <" + this.validate() + ">";
    }

    public static void main(String[] stringArray) {
        Range range = new Range(new Integer(1), new Integer(1000));
        System.out.println(" 1 = " + range);
        Range range2 = new Range(new Integer(1000), new Integer(1), new Integer(10));
        System.out.println(" 2 = " + range2);
        Range range3 = new Range(new Integer(1), new Integer(1000), new Integer(10));
        System.out.println(" 3 = " + range3);
        Range range4 = new Range(new Integer(1), new Integer(1000), new Integer(1));
        System.out.println(" 4 = " + range4);
        Range range5 = new Range(new Integer(1), new Integer(1000), new Integer(1000));
        System.out.println(" 5 = " + range5);
        Range range6 = new Range(new Integer(1), new Integer(1000), new Integer(0));
        System.out.println(" 6 = " + range6);
        Range range7 = new Range(new Integer(1), new Integer(1000), new Integer(1001));
        System.out.println(" 7 = " + range7);
    }

    public Object getCeiling() {
        return this.ceiling;
    }

    public void setCeiling(Object object) {
        this.ceiling = object;
    }

    public Object getFloor() {
        return this.floor;
    }

    public void setFloor(Object object) {
        this.floor = object;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }
}

